/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics;

import io.jaegertracing.analytics.ModelRunner;
import io.jaegertracing.analytics.gremlin.GraphCreator;
import io.jaegertracing.analytics.gremlin.TraceTraversal;
import io.jaegertracing.analytics.gremlin.TraceTraversalSource;
import io.jaegertracing.analytics.model.Span;
import io.opentracing.tag.Tags;
import io.prometheus.client.Counter;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class NumberOfErrors
implements ModelRunner {
    private static final Counter counter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("errors_total")).help("Number of errors split by service and operation name")).labelNames(new String[]{"service", "operation"})).create().register();

    @Override
    public void runWithMetrics(Graph graph) {
        Set<Span> errorSpans = NumberOfErrors.calculate(graph);
        for (Span span : errorSpans) {
            ((Counter.Child)counter.labels(new String[]{span.serviceName, span.operationName})).inc();
        }
    }

    public static Set<Span> calculate(Graph graph) {
        TraceTraversal<Vertex, Vertex> errorSpansTraversal = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).hasTag(Tags.ERROR.getKey(), "true");
        LinkedHashSet<Span> result = new LinkedHashSet<Span>();
        while (errorSpansTraversal.hasNext()) {
            Vertex errorSpanVertex = (Vertex)errorSpansTraversal.next();
            Span errorSpan = GraphCreator.toSpan(errorSpanVertex);
            result.add(errorSpan);
        }
        return result;
    }
}

