/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics;

import io.jaegertracing.analytics.ModelRunner;
import io.jaegertracing.analytics.gremlin.GraphCreator;
import io.jaegertracing.analytics.gremlin.TraceTraversal;
import io.jaegertracing.analytics.gremlin.TraceTraversalSource;
import io.jaegertracing.analytics.gremlin.Util;
import io.jaegertracing.analytics.model.Span;
import io.prometheus.client.Summary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ServiceDepth
implements ModelRunner {
    private static final Summary SERVICE_DEPTH_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().quantile(0.1, 0.01).quantile(0.2, 0.01).quantile(0.3, 0.01).quantile(0.4, 0.01).quantile(0.5, 0.01).quantile(0.6, 0.01).quantile(0.7, 0.01).quantile(0.8, 0.01).quantile(0.9, 0.01).quantile(0.99, 0.01).name("service_depth_total")).labelNames(new String[]{"service"})).help("Service depth - number of service hops from a service to the root service")).register();

    @Override
    public void runWithMetrics(Graph graph) {
        Map<String, Integer> depths = ServiceDepth.calculate(graph);
        for (Map.Entry<String, Integer> entry : depths.entrySet()) {
            ((Summary.Child)SERVICE_DEPTH_SUMMARY.labels(new String[]{entry.getKey()})).observe((double)entry.getValue().intValue());
        }
    }

    public static Map<String, Integer> calculate(Graph graph) {
        TraceTraversal<Vertex, Vertex> leafs = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).leafSpans();
        ArrayList depths = new ArrayList();
        HashSet<String> serviceNames = new HashSet<String>();
        while (leafs.hasNext()) {
            LinkedHashMap<String, Integer> branchDepths = new LinkedHashMap<String, Integer>();
            depths.add(branchDepths);
            Vertex node = (Vertex)leafs.next();
            Vertex parent = Util.parent(node);
            Span nodeSpan = GraphCreator.toSpan(node);
            branchDepths.put(nodeSpan.operationName, 0);
            serviceNames.add(nodeSpan.serviceName);
            while (parent != null) {
                Integer n;
                Span parentSpan = GraphCreator.toSpan(parent);
                if (!nodeSpan.serviceName.equals(parentSpan.serviceName)) {
                    for (String service : branchDepths.keySet()) {
                        Integer d = (Integer)branchDepths.get(service);
                        branchDepths.put(service, d + 1);
                    }
                }
                if ((n = (Integer)branchDepths.get(parentSpan.serviceName)) == null) {
                    branchDepths.put(parentSpan.serviceName, 0);
                    serviceNames.add(parentSpan.serviceName);
                }
                node = parent;
                nodeSpan = GraphCreator.toSpan(node);
                parent = Util.parent(parent);
            }
        }
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (String serviceName : serviceNames) {
            Integer depth = 0;
            for (Map map : depths) {
                Integer d = (Integer)map.get(serviceName);
                if (d == null || d <= depth) continue;
                depth = d;
            }
            result.put(serviceName, depth);
        }
        return result;
    }
}

