/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics;

import io.jaegertracing.analytics.ModelRunner;
import io.jaegertracing.analytics.gremlin.GraphCreator;
import io.jaegertracing.analytics.gremlin.TraceTraversal;
import io.jaegertracing.analytics.gremlin.TraceTraversalSource;
import io.jaegertracing.analytics.gremlin.Util;
import io.jaegertracing.analytics.model.Span;
import io.prometheus.client.Summary;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ServiceHeight
implements ModelRunner {
    private static final Summary SERVICE_HEIGHT_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().quantile(0.1, 0.01).quantile(0.2, 0.01).quantile(0.3, 0.01).quantile(0.4, 0.01).quantile(0.5, 0.01).quantile(0.6, 0.01).quantile(0.7, 0.01).quantile(0.8, 0.01).quantile(0.9, 0.01).quantile(0.99, 0.01).name("service_height_total")).labelNames(new String[]{"service"})).help("Service height - number of service hops from a service to the leaf service")).register();

    @Override
    public void runWithMetrics(Graph graph) {
        Map<String, Integer> depths = ServiceHeight.calculate(graph);
        for (Map.Entry<String, Integer> entry : depths.entrySet()) {
            ((Summary.Child)SERVICE_HEIGHT_SUMMARY.labels(new String[]{entry.getKey()})).observe((double)entry.getValue().intValue());
        }
    }

    public static Map<String, Integer> calculate(Graph graph) {
        TraceTraversal<Vertex, Vertex> leafs = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).leafSpans();
        LinkedHashMap<String, Integer> heights = new LinkedHashMap<String, Integer>();
        while (leafs.hasNext()) {
            int height = 0;
            Vertex node = (Vertex)leafs.next();
            Vertex parent = Util.parent(node);
            Span nodeSpan = GraphCreator.toSpan(node);
            Integer heightNode = (Integer)heights.get(nodeSpan.serviceName);
            if (heightNode == null) {
                heights.put(nodeSpan.serviceName, height);
            }
            while (parent != null) {
                Span parentSpan = GraphCreator.toSpan(parent);
                if (!nodeSpan.serviceName.equals(parentSpan.serviceName)) {
                    ++height;
                }
                if ((heightNode = (Integer)heights.get(parentSpan.serviceName)) == null || height > heightNode) {
                    heights.put(parentSpan.serviceName, height);
                }
                node = parent;
                nodeSpan = GraphCreator.toSpan(node);
                parent = Util.parent(parent);
            }
        }
        return heights;
    }
}

