/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics;

import io.jaegertracing.analytics.ModelRunner;
import io.jaegertracing.analytics.gremlin.TraceTraversal;
import io.jaegertracing.analytics.gremlin.TraceTraversalSource;
import io.jaegertracing.analytics.gremlin.__;
import io.prometheus.client.Summary;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class TraceHeight
implements ModelRunner {
    private static final Summary TRACE_HEIGHT_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().quantile(0.1, 0.01).quantile(0.2, 0.01).quantile(0.3, 0.01).quantile(0.4, 0.01).quantile(0.5, 0.01).quantile(0.6, 0.01).quantile(0.7, 0.01).quantile(0.8, 0.01).quantile(0.9, 0.01).quantile(0.99, 0.01).name("trace_height_total")).help("Trace height - maximum number of spans from root to leaf")).register();

    @Override
    public void runWithMetrics(Graph graph) {
        int height = TraceHeight.calculate(graph);
        TRACE_HEIGHT_SUMMARY.observe((double)height);
    }

    public static int calculate(Graph graph) {
        TraceTraversal maxHeight = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).V(new Object[0]).repeat((Traversal<?, Vertex>)__.in(new String[0])).emit().path().count(Scope.local).max();
        List heights = maxHeight.toStream().map(height -> Integer.valueOf(height.toString())).collect(Collectors.toList());
        return heights.size() > 0 ? (Integer)heights.get(0) - 1 : 0;
    }
}

