/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics.gremlin;

import io.jaegertracing.analytics.gremlin.ExampleTrace;
import io.jaegertracing.analytics.gremlin.TraceTraversal;
import io.jaegertracing.analytics.gremlin.TraceTraversalSource;
import io.jaegertracing.analytics.gremlin.Util;
import io.jaegertracing.analytics.gremlin.__;
import io.opentracing.tag.Tags;
import java.util.List;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public class Examples {
    public static void main(String[] args) {
        TinkerGraph graph = TinkerGraph.open();
        ExampleTrace.initData((Graph)graph);
        TraceTraversal<Vertex, Vertex> traversal = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).hasTag(Tags.SPAN_KIND.getKey()).rootSpan().duration((Predicate<Integer>)P.gt((Object)2));
        Vertex vertex = (Vertex)traversal.next();
        Util.printVertex(vertex);
        Util.dfs(vertex, v -> Util.printVertex(v));
        traversal = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).hasTag(Tags.SPAN_KIND.getKey(), "client").duration((Predicate<Integer>)P.gt((Object)120));
        System.out.println("--------");
        traversal.forEachRemaining(v -> Util.printVertex(v));
        TraceTraversal by = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).hasTag(Tags.SPAN_KIND.getKey(), "client").duration((Predicate<Integer>)P.gt((Object)120)).group().by("traceId");
        System.out.println("--------");
        by.forEachRemaining(map -> {
            System.out.println(map.keySet());
            map.values().forEach(o -> {
                List vertices = (List)o;
                vertices.forEach(vv -> Util.printVertex(vv));
            });
        });
        traversal = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).hasName("root").repeat((Traversal<?, Vertex>)__.out(new String[0])).until((Traversal<?, ?>)__.hasName("child2"));
        System.out.println("\nIs root span connected with (tag/operation name)?");
        traversal.forEachRemaining(v -> Util.printVertex(v));
        TraceTraversal<Vertex, Path> pathTraversal = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).hasName("root").repeat((Traversal<?, Vertex>)__.out(new String[0])).until((Traversal<?, ?>)__.hasName("child2")).path();
        System.out.println("\nWhat is the path between two spans?");
        pathTraversal.clone().forEachRemaining(path -> System.out.println(path.size()));
        pathTraversal.forEachRemaining(path -> Util.printPath(path));
        TraceTraversal height = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).V(new Object[0]).repeat((Traversal<?, Vertex>)__.in(new String[0])).emit().path().count(Scope.local).max();
        System.out.println("\nMax trace height");
        height.forEachRemaining(comparable -> System.out.println(comparable));
    }
}

