/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics.gremlin;

import io.jaegertracing.analytics.model.Span;
import io.jaegertracing.analytics.model.Trace;
import java.util.LinkedHashMap;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public class GraphCreator {
    private GraphCreator() {
    }

    public static Graph create(Trace trace) {
        Vertex vertex;
        TinkerGraph graph = TinkerGraph.open();
        LinkedHashMap<String, Vertex> vertexMap = new LinkedHashMap<String, Vertex>();
        for (Span span : trace.spans) {
            vertex = graph.addVertex("span");
            vertexMap.put(span.spanId, vertex);
            vertex.property("span", (Object)span);
            vertex.property("traceId", (Object)span.traceId);
            vertex.property("spanId", (Object)span.spanId);
            if (span.parentId != null) {
                vertex.property("parentId", (Object)span.parentId);
            }
            vertex.property("startTime", (Object)span.startTimeMicros);
            vertex.property("duration", (Object)span.durationMicros);
            vertex.property("serviceName", (Object)span.serviceName);
            vertex.property("operationName", (Object)span.operationName);
            span.tags.entrySet().forEach(stringStringEntry -> vertex.property((String)stringStringEntry.getKey(), stringStringEntry.getValue()));
        }
        for (Span span : trace.spans) {
            Vertex parent;
            vertex = (Vertex)vertexMap.get(span.spanId);
            if (span.parentId == null || (parent = (Vertex)vertexMap.get(span.parentId)) == null) continue;
            parent.addEdge("child_of", vertex, new Object[0]);
        }
        return graph;
    }

    public static Span toSpan(Vertex vertex) {
        return (Span)vertex.property("span").value();
    }
}

