/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics.gremlin;

import io.jaegertracing.analytics.gremlin.TraceTraversalSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class Util {
    private Util() {
    }

    public static TraceTraversalSource traceTraversal(Graph graph) {
        return (TraceTraversalSource)graph.traversal(TraceTraversalSource.class);
    }

    public static void dfs(Vertex node, Consumer<Vertex> vertexConsumer) {
        vertexConsumer.accept(node);
        Iterator edges = node.edges(Direction.OUT, new String[]{"child_of"});
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            Util.dfs(edge.inVertex(), vertexConsumer);
        }
    }

    public static void dfs(Vertex node, BiConsumer<Vertex, Vertex> vertexConsumer) {
        Iterator edges = node.edges(Direction.OUT, new String[]{"child_of"});
        if (!edges.hasNext()) {
            vertexConsumer.accept(node, null);
        }
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            vertexConsumer.accept(node, edge.inVertex());
            Util.dfs(edge.inVertex(), vertexConsumer);
        }
    }

    public static Vertex parent(Vertex vertex) {
        Iterator edges = vertex.edges(Direction.IN, new String[]{"child_of"});
        if (!edges.hasNext()) {
            return null;
        }
        return ((Edge)edges.next()).outVertex();
    }

    public static List<Vertex> children(Vertex vertex) {
        Iterator edges = vertex.edges(Direction.OUT, new String[]{"child_of"});
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            vertices.add(edge.inVertex());
        }
        return Collections.unmodifiableList(vertices);
    }

    public static void printVertex(Vertex vertex) {
        String operation = vertex.property("operationName") != null ? String.valueOf(vertex.property("operationName").value()) : "null";
        String traceId = vertex.property("traceId") != null ? String.valueOf(vertex.property("traceId").value()) : "null";
        String spanId = vertex.property("spanId") != null ? String.valueOf(vertex.property("spanId").value()) : "null";
        System.out.printf("%s[%s:%s], tags = %s\n", operation, traceId, spanId, vertex.keys());
    }

    public static void printPath(Path path) {
        System.out.printf("Size=%d\n", path.size());
        Iterator iterator = path.iterator();
        while (iterator.hasNext()) {
            Vertex vertex = (Vertex)iterator.next();
            Util.printVertex(vertex);
            if (!iterator.hasNext()) continue;
            System.out.println("|");
        }
    }
}

