/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics.model;

import com.google.protobuf.ByteString;
import io.jaegertracing.analytics.model.Span;
import io.jaegertracing.analytics.model.Trace;
import io.jaegertracing.api_v2.Model;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Converter {
    private Converter() {
    }

    public static Trace toModel(List<Model.Span> spanList) {
        Trace trace = new Trace();
        for (Model.Span protoSpan : spanList) {
            if (trace.traceId == null || trace.traceId.isEmpty()) {
                trace.traceId = Converter.toStringId(protoSpan.getTraceId());
            }
            trace.spans.add(Converter.toModel(protoSpan));
        }
        return trace;
    }

    public static Collection<Trace> toModelTraces(List<Model.Span> spanList) {
        LinkedHashMap<String, Trace> traces = new LinkedHashMap<String, Trace>();
        for (Model.Span protoSpan : spanList) {
            Span span = Converter.toModel(protoSpan);
            Trace trace = (Trace)traces.get(span.traceId);
            if (trace == null) {
                trace = new Trace();
                trace.traceId = span.traceId;
                traces.put(span.traceId, trace);
            }
            trace.spans.add(span);
        }
        return traces.values();
    }

    public static Span toModel(Model.Span protoSpan) {
        Span span = new Span();
        span.spanId = Converter.toStringId(protoSpan.getSpanId());
        span.traceId = Converter.toStringId(protoSpan.getTraceId());
        if (protoSpan.getReferencesList().size() > 0) {
            span.parentId = Converter.toStringId(((Model.SpanRef)protoSpan.getReferencesList().get(0)).getSpanId());
        }
        span.serviceName = protoSpan.getProcess().getServiceName();
        span.operationName = protoSpan.getOperationName();
        span.startTimeMicros = protoSpan.getStartTime().getNanos() / 1000;
        span.durationMicros = protoSpan.getDuration().getNanos() / 1000;
        span.tags = Converter.toMap(protoSpan.getTagsList());
        span.logs = new ArrayList<Span.Log>();
        for (Model.Log protoLog : protoSpan.getLogsList()) {
            Span.Log log = new Span.Log();
            log.timestamp = protoLog.getTimestamp().getNanos() / 1000;
            log.fields = Converter.toMap(protoLog.getFieldsList());
            span.logs.add(log);
        }
        return span;
    }

    private static Map<String, String> toMap(List<Model.KeyValue> tags) {
        LinkedHashMap<String, String> tagMap = new LinkedHashMap<String, String>();
        for (Model.KeyValue keyValue : tags) {
            switch (keyValue.getVType()) {
                default: 
            }
            tagMap.put(keyValue.getKey(), Converter.toStringValue(keyValue));
        }
        return tagMap;
    }

    private static String toStringValue(Model.KeyValue keyValue) {
        switch (keyValue.getVType()) {
            case STRING: {
                return keyValue.getVStr();
            }
            case BOOL: {
                return Boolean.toString(keyValue.getVBool());
            }
            case INT64: {
                return Long.toString(keyValue.getVInt64());
            }
            case FLOAT64: {
                return Double.toString(keyValue.getVFloat64());
            }
            case BINARY: {
                return keyValue.getVBinary().toStringUtf8();
            }
        }
        return "unrecognized";
    }

    public static String toStringId(ByteString id) {
        return new BigInteger(1, id.toByteArray()).toString(16);
    }

    public static ByteString toProtoId(String id) {
        return ByteString.copyFrom((byte[])new BigInteger(id, 16).toByteArray());
    }
}

