/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics.tracequality;

import io.jaegertracing.analytics.ModelRunner;
import io.jaegertracing.analytics.gremlin.GraphCreator;
import io.jaegertracing.analytics.gremlin.TraceTraversal;
import io.jaegertracing.analytics.gremlin.TraceTraversalSource;
import io.jaegertracing.analytics.gremlin.Util;
import io.jaegertracing.analytics.model.Span;
import io.opentracing.tag.Tags;
import io.prometheus.client.Counter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class HasClientServerSpans
implements ModelRunner {
    private static final Counter counterClientTag = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("trace_quality_client_tag_total")).help("The service emits spans with client span.kind")).labelNames(new String[]{"pass", "service"})).create().register();
    private static final Counter counterServerTag = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("trace_quality_server_tag_total")).help("The service emits spans with server span.kind")).labelNames(new String[]{"pass", "service"})).create().register();

    @Override
    public void runWithMetrics(Graph graph) {
        Result result = this.computeScore(graph);
        for (Span span : result.missingServerTag) {
            ((Counter.Child)counterServerTag.labels(new String[]{"false", span.serviceName})).inc();
        }
        for (Span span : result.missingClientTag) {
            ((Counter.Child)counterClientTag.labels(new String[]{"false", span.serviceName})).inc();
        }
        for (Span span : result.hasClientTag) {
            ((Counter.Child)counterClientTag.labels(new String[]{"true", span.serviceName})).inc();
        }
        for (Span span : result.hasServerTag) {
            ((Counter.Child)counterServerTag.labels(new String[]{"true", span.serviceName})).inc();
        }
    }

    public Result computeScore(Graph graph) {
        Span span;
        String peerService;
        Vertex vertex;
        Result result = new Result();
        TraceTraversal<Vertex, Vertex> traversal = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).hasTag(Tags.SPAN_KIND.getKey(), "client");
        while (traversal.hasNext()) {
            vertex = (Vertex)traversal.next();
            List<Vertex> children = Util.children(vertex);
            if (children == null || children.isEmpty()) {
                Span clientSpan = GraphCreator.toSpan(vertex);
                peerService = clientSpan.tags.get(Tags.PEER_SERVICE.getKey());
                if (peerService == null) continue;
                span = new Span();
                span.serviceName = peerService;
                result.missingServerTag.add(span);
                continue;
            }
            for (Vertex child : children) {
                Span childSpan = GraphCreator.toSpan(child);
                String spanKindTag = childSpan.tags.get(Tags.SPAN_KIND.getKey());
                if (!"server".equals(spanKindTag)) {
                    result.missingServerTag.add(childSpan);
                    continue;
                }
                result.hasServerTag.add(childSpan);
            }
        }
        traversal = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).hasTag(Tags.SPAN_KIND.getKey(), "server");
        while (traversal.hasNext()) {
            vertex = (Vertex)traversal.next();
            Vertex parent = Util.parent(vertex);
            if (parent == null) {
                Span serverSpan = GraphCreator.toSpan(vertex);
                peerService = serverSpan.tags.get(Tags.PEER_SERVICE.getKey());
                if (peerService == null) continue;
                span = new Span();
                span.serviceName = peerService;
                result.missingClientTag.add(span);
                continue;
            }
            Span parentSpan = GraphCreator.toSpan(parent);
            String spanKindTag = parentSpan.tags.get(Tags.SPAN_KIND.getKey());
            if (!"client".equals(spanKindTag)) {
                result.missingClientTag.add(parentSpan);
                continue;
            }
            result.hasClientTag.add(parentSpan);
        }
        return result;
    }

    public static class Result {
        public List<Span> missingClientTag = new ArrayList<Span>();
        public List<Span> missingServerTag = new ArrayList<Span>();
        public List<Span> hasServerTag = new ArrayList<Span>();
        public List<Span> hasClientTag = new ArrayList<Span>();
    }
}

