/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics.tracequality;

import io.jaegertracing.analytics.ModelRunner;
import io.jaegertracing.analytics.gremlin.GraphCreator;
import io.jaegertracing.analytics.model.Span;
import io.prometheus.client.Counter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class MinimumClientVersion
implements ModelRunner {
    static final String VERSION_TAG = "jaeger.version";
    static final String MISSING_VERSION = "none";
    private final Map<String, String> languageToMinVersion;
    private static final Counter counter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("trace_quality_minimum_client_version_total")).help("The service emitted spans with Jaeger client version")).labelNames(new String[]{"pass", "service", "version"})).create().register();

    public static Builder builder() {
        return new Builder();
    }

    private MinimumClientVersion(final Builder builder) {
        this.languageToMinVersion = Collections.unmodifiableMap(new HashMap<String, String>(){
            {
                this.put("go", builder.goVersion);
                this.put("python", builder.pythonVersion);
                this.put("node", builder.nodeVersion);
                this.put("java", builder.javaVersion);
            }
        });
    }

    @Override
    public void runWithMetrics(Graph graph) {
        Iterator vertices = graph.vertices(new Object[0]);
        while (vertices.hasNext()) {
            Vertex vertex = (Vertex)vertices.next();
            Span span = GraphCreator.toSpan(vertex);
            String jaegerVersion = span.tags.get(VERSION_TAG);
            if (jaegerVersion == null || jaegerVersion.isEmpty()) {
                jaegerVersion = MISSING_VERSION;
            }
            boolean result = this.computeScore(span);
            ((Counter.Child)counter.labels(new String[]{Boolean.toString(result), span.serviceName, jaegerVersion})).inc();
        }
    }

    public boolean computeScore(Span span) {
        String version = span.tags.get(VERSION_TAG);
        if (version == null || version.isEmpty()) {
            return false;
        }
        String[] languageVersion = version.toLowerCase().split("-");
        if (languageVersion.length != 2 || this.languageToMinVersion.get(languageVersion[0]) == null || !languageVersion[1].matches("[0-9]+(\\.[0-9]+)*")) {
            return false;
        }
        return this.isGreaterThanOrEqualTo(this.languageToMinVersion.get(languageVersion[0]), languageVersion[1]);
    }

    boolean isGreaterThanOrEqualTo(String left, String right) {
        String[] leftParts = left.split("\\.");
        String[] rightParts = right.split("\\.");
        int length = Math.min(leftParts.length, rightParts.length);
        try {
            for (int i = 0; i < length; ++i) {
                int rightPart;
                int leftPart = Integer.parseInt(leftParts[i]);
                if (leftPart < (rightPart = Integer.parseInt(rightParts[i]))) {
                    return true;
                }
                if (leftPart <= rightPart) continue;
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static class Builder
    implements Serializable {
        private String javaVersion = "1.0.0";
        private String nodeVersion = "3.17.1";
        private String goVersion = "2.22.0";
        private String pythonVersion = "4.0.0";

        private Builder() {
        }

        public MinimumClientVersion build() {
            return new MinimumClientVersion(this);
        }

        public Builder withJavaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
            return this;
        }

        public Builder withNodeVersion(String nodeVersion) {
            this.nodeVersion = nodeVersion;
            return this;
        }

        public Builder withGoVersion(String goVersion) {
            this.goVersion = goVersion;
            return this;
        }

        public Builder withPythonVersion(String pythonVersion) {
            this.pythonVersion = pythonVersion;
            return this;
        }
    }
}

