/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics.tracequality;

import io.jaegertracing.analytics.ModelRunner;
import io.jaegertracing.analytics.gremlin.GraphCreator;
import io.jaegertracing.analytics.gremlin.TraceTraversal;
import io.jaegertracing.analytics.gremlin.Util;
import io.jaegertracing.analytics.model.Span;
import io.prometheus.client.Counter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class UniqueSpanId
implements ModelRunner {
    private static final Counter counter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("trace_quality_unique_span_id_total")).help("The service emitted spans with unique span IDs")).labelNames(new String[]{"pass", "service"})).create().register();

    @Override
    public void runWithMetrics(Graph graph) {
        Map<String, List<Span>> result = UniqueSpanId.computeScore(graph);
        for (Map.Entry<String, List<Span>> entry : result.entrySet()) {
            List<Span> spans = entry.getValue();
            boolean uniqueId = spans.size() == 1;
            for (Span span : entry.getValue()) {
                ((Counter.Child)counter.labels(new String[]{String.valueOf(uniqueId), span.serviceName})).inc();
            }
        }
    }

    public static Map<String, List<Span>> computeScore(Graph graph) {
        TraceTraversal by = Util.traceTraversal(graph).V(new Object[0]).group().by("spanId");
        LinkedHashMap<String, List<Span>> result = new LinkedHashMap<String, List<Span>>();
        while (by.hasNext()) {
            Map map = (Map)by.next();
            for (Map.Entry entry : map.entrySet()) {
                Collection vertices = (Collection)entry.getValue();
                String id = (String)entry.getKey();
                ArrayList<Span> spans = (ArrayList<Span>)result.get(id);
                if (spans == null) {
                    spans = new ArrayList<Span>(vertices.size());
                    result.put(id, spans);
                }
                for (Vertex vertex : vertices) {
                    Span span = GraphCreator.toSpan(vertex);
                    spans.add(span);
                }
            }
        }
        return result;
    }
}

