/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.zipkin.internal;

import com.twitter.zipkin.thriftjava.Span;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.Encoding;

public final class ThriftSpanEncoder
implements BytesEncoder<Span> {
    final ThreadLocal<ReusableTBinaryProtocol> protocol = new ThreadLocal<ReusableTBinaryProtocol>(){

        @Override
        protected ReusableTBinaryProtocol initialValue() {
            try {
                return new ReusableTBinaryProtocol(new ByteArrayOutputStream());
            }
            catch (TTransportException e) {
                throw new RuntimeException("Unable to initialise protocol: " + (Object)((Object)e), e);
            }
        }
    };

    public Encoding encoding() {
        return Encoding.THRIFT;
    }

    public int sizeInBytes(Span input) {
        throw new UnsupportedOperationException("unused by internal code");
    }

    public byte[] encode(Span thriftSpan) {
        this.protocol.get().baos.reset();
        try {
            thriftSpan.write((TProtocol)this.protocol.get());
            return this.protocol.get().baos.toByteArray();
        }
        catch (TException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] encodeList(List<Span> input) {
        throw new UnsupportedOperationException("unused by internal code");
    }

    static class ReusableTBinaryProtocol
    extends TBinaryProtocol {
        private final ByteArrayOutputStream baos;

        ReusableTBinaryProtocol(ByteArrayOutputStream baos) throws TTransportException {
            super((TTransport)new TIOStreamTransport((OutputStream)baos));
            this.baos = baos;
        }
    }
}

