/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jafka.jeos.EosApi;
import io.jafka.jeos.core.common.SignArg;
import io.jafka.jeos.core.common.WalletKeyType;
import io.jafka.jeos.core.common.transaction.PackedTransaction;
import io.jafka.jeos.core.common.transaction.SignedPackedTransaction;
import io.jafka.jeos.core.request.chain.AbiJsonToBinRequest;
import io.jafka.jeos.core.request.chain.RequiredKeysRequest;
import io.jafka.jeos.core.request.chain.transaction.PushTransactionRequest;
import io.jafka.jeos.core.request.history.TransactionRequest;
import io.jafka.jeos.core.request.wallet.transaction.SignTransactionRequest;
import io.jafka.jeos.core.response.chain.AbiBinToJson;
import io.jafka.jeos.core.response.chain.AbiJsonToBin;
import io.jafka.jeos.core.response.chain.Block;
import io.jafka.jeos.core.response.chain.ChainInfo;
import io.jafka.jeos.core.response.chain.RequiredKeys;
import io.jafka.jeos.core.response.chain.TableRow;
import io.jafka.jeos.core.response.chain.abi.Abi;
import io.jafka.jeos.core.response.chain.account.Account;
import io.jafka.jeos.core.response.chain.code.Code;
import io.jafka.jeos.core.response.chain.currencystats.CurrencyStats;
import io.jafka.jeos.core.response.chain.transaction.PushedTransaction;
import io.jafka.jeos.core.response.history.action.Actions;
import io.jafka.jeos.core.response.history.controlledaccounts.ControlledAccounts;
import io.jafka.jeos.core.response.history.keyaccounts.KeyAccounts;
import io.jafka.jeos.impl.EosApiServiceGenerator;
import io.jafka.jeos.impl.EosChainApiService;
import io.jafka.jeos.impl.EosHistoryApiService;
import io.jafka.jeos.impl.EosWalletApiService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EosApiRestClientImpl
implements EosApi {
    private final EosWalletApiService eosWalletApiService;
    private final EosChainApiService eosChainApiService;
    private final EosHistoryApiService eosHistoryApiService;

    public EosApiRestClientImpl(String baseUrl) {
        this.eosWalletApiService = EosApiServiceGenerator.createService(EosWalletApiService.class, baseUrl);
        this.eosChainApiService = EosApiServiceGenerator.createService(EosChainApiService.class, baseUrl);
        this.eosHistoryApiService = EosApiServiceGenerator.createService(EosHistoryApiService.class, baseUrl);
    }

    public EosApiRestClientImpl(String walletBaseUrl, String chainBaseUrl, String historyBaseUrl) {
        this.eosWalletApiService = EosApiServiceGenerator.createService(EosWalletApiService.class, walletBaseUrl);
        this.eosChainApiService = EosApiServiceGenerator.createService(EosChainApiService.class, chainBaseUrl);
        this.eosHistoryApiService = EosApiServiceGenerator.createService(EosHistoryApiService.class, historyBaseUrl);
    }

    @Override
    public ChainInfo getChainInfo() {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.getChainInfo());
    }

    @Override
    public Block getBlock(String blockNumberOrId) {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.getBlock(Collections.singletonMap("block_num_or_id", blockNumberOrId)));
    }

    @Override
    public Account getAccount(String accountName) {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.getAccount(Collections.singletonMap("account_name", accountName)));
    }

    @Override
    public Abi getAbi(String accountName) {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.getAbi(Collections.singletonMap("account_name", accountName)));
    }

    @Override
    public Code getCode(String accountName) {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.getCode(Collections.singletonMap("account_name", accountName)));
    }

    @Override
    public TableRow getTableRows(String scope, String code, String table) {
        LinkedHashMap<String, String> requestParameters = new LinkedHashMap<String, String>(7);
        requestParameters.put("scope", scope);
        requestParameters.put("code", code);
        requestParameters.put("table", table);
        requestParameters.put("json", "true");
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.getTableRows(requestParameters));
    }

    @Override
    public List<String> getCurrencyBalance(String code, String accountName, String symbol) {
        LinkedHashMap<String, String> requestParameters = new LinkedHashMap<String, String>(3);
        requestParameters.put("code", code);
        requestParameters.put("account", accountName);
        requestParameters.put("symbol", symbol);
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.getCurrencyBalance(requestParameters));
    }

    @Override
    public AbiBinToJson abiBinToJson(String code, String action, String binargs) {
        LinkedHashMap<String, String> requestParameters = new LinkedHashMap<String, String>(3);
        requestParameters.put("code", code);
        requestParameters.put("action", action);
        requestParameters.put("binargs", binargs);
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.abiBinToJson(requestParameters));
    }

    @Override
    public <T> AbiJsonToBin abiJsonToBin(String code, String action, T args) {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.abiJsonToBin(new AbiJsonToBinRequest<T>(code, action, args)));
    }

    @Override
    public PushedTransaction pushTransaction(String compression, SignedPackedTransaction packedTransaction) {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.pushTransaction(new PushTransactionRequest(compression, packedTransaction, packedTransaction.getSignatures())));
    }

    @Override
    public PushedTransaction pushTransaction(PushTransactionRequest pushTransactionRequest) {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.pushTransaction(pushTransactionRequest));
    }

    @Override
    public List<PushedTransaction> pushTransactions(List<PushTransactionRequest> pushTransactionRequests) {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.pushTransactions(pushTransactionRequests));
    }

    @Override
    public RequiredKeys getRequiredKeys(PackedTransaction transaction, List<String> keys) {
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.getRequiredKeys(new RequiredKeysRequest(transaction, keys)));
    }

    @Override
    public Map<String, CurrencyStats> getCurrencyStats(String code, String symbol) {
        LinkedHashMap<String, String> requestParameters = new LinkedHashMap<String, String>(2);
        requestParameters.put("code", code);
        requestParameters.put("symbol", symbol);
        return EosApiServiceGenerator.executeSync(this.eosChainApiService.getCurrencyStats(requestParameters));
    }

    @Override
    public String createWallet(String walletName) {
        return EosApiServiceGenerator.executeSync(this.eosWalletApiService.createWallet(walletName));
    }

    @Override
    public void openWallet(String walletName) {
        EosApiServiceGenerator.executeSync(this.eosWalletApiService.openWallet(walletName));
    }

    @Override
    public void lockWallet(String walletName) {
        EosApiServiceGenerator.executeSync(this.eosWalletApiService.lockWallet(walletName));
    }

    @Override
    public void lockAllWallets() {
        EosApiServiceGenerator.executeSync(this.eosWalletApiService.lockAll());
    }

    @Override
    public void unlockWallet(String walletName, String walletPassword) {
        ArrayList<String> requestFields = new ArrayList<String>(2);
        requestFields.add(walletName);
        requestFields.add(walletPassword);
        EosApiServiceGenerator.executeSync(this.eosWalletApiService.unlockWallet(requestFields));
    }

    @Override
    public void importKeyIntoWallet(String walletName, String key) {
        ArrayList<String> requestFields = new ArrayList<String>(2);
        requestFields.add(walletName);
        requestFields.add(key);
        EosApiServiceGenerator.executeSync(this.eosWalletApiService.importKey(requestFields));
    }

    @Override
    public List<String> listWallets() {
        return EosApiServiceGenerator.executeSync(this.eosWalletApiService.listWallets());
    }

    @Override
    public List<List<String>> listKeys(String walletName, String password) {
        List<String> requestFields = Arrays.asList(walletName, password);
        return EosApiServiceGenerator.executeSync(this.eosWalletApiService.listKeys(requestFields));
    }

    @Override
    public List<String> getPublicKeys() {
        return EosApiServiceGenerator.executeSync(this.eosWalletApiService.getPublicKeys());
    }

    @Override
    public SignedPackedTransaction signTransaction(PackedTransaction packedTransaction, List<String> publicKeys, String chainId) {
        return EosApiServiceGenerator.executeSync(this.eosWalletApiService.signTransaction(new SignTransactionRequest(packedTransaction, publicKeys, chainId)));
    }

    @Override
    public void setWalletTimeout(Integer timeout) {
        EosApiServiceGenerator.executeSync(this.eosWalletApiService.setTimeout(timeout));
    }

    @Override
    public String signDigest(String digest, String publicKey) {
        return EosApiServiceGenerator.executeSync(this.eosWalletApiService.signDigest(Arrays.asList(digest, publicKey)));
    }

    @Override
    public String createKey(String walletName, WalletKeyType keyType) {
        return EosApiServiceGenerator.executeSync(this.eosWalletApiService.createKey(Arrays.asList(walletName, keyType.name())));
    }

    @Override
    public Actions getActions(String accountName, Integer pos, Integer offset) {
        LinkedHashMap<String, Object> requestParameters = new LinkedHashMap<String, Object>(3);
        requestParameters.put("account_name", accountName);
        requestParameters.put("pos", pos);
        requestParameters.put("offset", offset);
        return EosApiServiceGenerator.executeSync(this.eosHistoryApiService.getActions(requestParameters));
    }

    @Override
    public Object getTransaction(TransactionRequest transactionRequest) {
        return EosApiServiceGenerator.executeSync(this.eosHistoryApiService.getTransaction(transactionRequest));
    }

    @Override
    public KeyAccounts getKeyAccounts(String publicKey) {
        LinkedHashMap<String, String> requestParameters = new LinkedHashMap<String, String>(1);
        requestParameters.put("public_key", publicKey);
        return EosApiServiceGenerator.executeSync(this.eosHistoryApiService.getKeyAccounts(requestParameters));
    }

    @Override
    public ControlledAccounts getControlledAccounts(String controllingAccountName) {
        LinkedHashMap<String, String> requestParameters = new LinkedHashMap<String, String>(1);
        requestParameters.put("controlling_account", controllingAccountName);
        return EosApiServiceGenerator.executeSync(this.eosHistoryApiService.getControlledAccounts(requestParameters));
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return EosApiServiceGenerator.getMapper();
    }

    @Override
    public SignArg getSignArg(int expiredSecond) {
        ChainInfo info = this.getChainInfo();
        Block block = this.getBlock(info.getLastIrreversibleBlockNum().toString());
        SignArg arg = new SignArg();
        arg.setChainId(info.getChainId());
        arg.setExpiredSecond(expiredSecond);
        arg.setHeadBlockNum(info.getHeadBlockNum());
        arg.setHeadBlockTime(info.getHeadBlockTime());
        arg.setLastIrreversibleBlockNum(info.getLastIrreversibleBlockNum());
        arg.setRefBlockPrefix(block.getRefBlockPrefix());
        return arg;
    }
}

