/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.jafka.jeos.exception.EosApiError;
import io.jafka.jeos.exception.EosApiErrorCode;
import io.jafka.jeos.exception.EosApiException;
import io.jafka.jeos.exception.ErrorCode;
import io.jafka.jeos.impl.LoggingInterceptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class EosApiServiceGenerator {
    private static OkHttpClient httpClient;
    private static Retrofit retrofit;
    private static ObjectMapper mapper;

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static <S> S createService(Class<S> serviceClass, String baseUrl) {
        Retrofit.Builder builder = new Retrofit.Builder();
        builder.baseUrl(baseUrl);
        builder.client(httpClient);
        builder.addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper));
        retrofit = builder.build();
        return (S)retrofit.create(serviceClass);
    }

    public static <T> T executeSync(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            EosApiError apiError = EosApiServiceGenerator.getEosApiError(response);
            throw new EosApiException(apiError.getDetailedMessage(), (ErrorCode)EosApiErrorCode.get(apiError.getEosErrorCode()));
        }
        catch (IOException e) {
            throw new EosApiException(e);
        }
    }

    private static EosApiError getEosApiError(Response<?> response) throws IOException, EosApiException {
        return (EosApiError)retrofit.responseBodyConverter(EosApiError.class, new Annotation[0]).convert((Object)response.errorBody());
    }

    static {
        mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.SnakeCaseStrategy());
        mapper.findAndRegisterModules();
        httpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new LoggingInterceptor()).build();
    }
}

