/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.util.ecc;

import io.jafka.jeos.util.ecc.FieldElement;
import io.jafka.jeos.util.ecc.Point;
import java.math.BigInteger;

public class Curve {
    private FieldElement a;
    private FieldElement b;
    private BigInteger q;
    private Point infinity;
    private BigInteger pOverFour;

    public Curve(BigInteger q, BigInteger a, BigInteger b) {
        this.q = q;
        this.a = this.fromBigInteger(a);
        this.b = this.fromBigInteger(b);
        this.infinity = new Point(this, null, null);
        this.pOverFour = q.add(BigInteger.ONE).shiftRight(2);
    }

    public FieldElement getA() {
        return this.a;
    }

    public FieldElement getB() {
        return this.b;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public Point getInfinity() {
        return this.infinity;
    }

    public int getFieldSize() {
        return this.q.bitLength();
    }

    public FieldElement fromBigInteger(BigInteger x) {
        return new FieldElement(this.q, x);
    }

    public Point pointFromX(int isOdd, BigInteger x) {
        BigInteger beta;
        FieldElement f = this.a.multiply(this.fromBigInteger(x));
        BigInteger alpha = x.pow(3).add(f.toBigInteger()).add(this.b.toBigInteger()).mod(this.q);
        BigInteger y = beta = alpha.modPow(this.pOverFour, this.q);
        if (beta.intValue() % 2 == 0 ^ isOdd == 0) {
            y = this.q.subtract(y);
        }
        return new Point(this, new FieldElement(this.q, x), new FieldElement(this.q, y), false);
    }

    public Point decodePoint(byte[] encodedPoint) {
        Point p = null;
        switch (encodedPoint[0]) {
            case 0: {
                p = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                int bit0;
                int ytilde = encodedPoint[0] & 1;
                byte[] i = new byte[encodedPoint.length - 1];
                System.arraycopy(encodedPoint, 1, i, 0, i.length);
                FieldElement x = new FieldElement(this.q, new BigInteger(1, i));
                FieldElement alpha = x.multiply(x.square().add(this.a)).add(this.b);
                FieldElement beta = alpha.sqrt();
                if (beta == null) {
                    throw new RuntimeException("Invalid compression");
                }
                int n = bit0 = beta.toBigInteger().testBit(0) ? 1 : 0;
                if (bit0 == ytilde) {
                    p = new Point(this, x, beta, true);
                    break;
                }
                p = new Point(this, x, new FieldElement(this.q, this.q.subtract(beta.toBigInteger())), true);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                byte[] xEnc = new byte[(encodedPoint.length - 1) / 2];
                byte[] yEnc = new byte[(encodedPoint.length - 1) / 2];
                System.arraycopy(encodedPoint, 1, xEnc, 0, xEnc.length);
                System.arraycopy(encodedPoint, xEnc.length + 1, yEnc, 0, yEnc.length);
                p = new Point(this, new FieldElement(this.q, new BigInteger(1, xEnc)), new FieldElement(this.q, new BigInteger(1, yEnc)));
                break;
            }
            default: {
                throw new RuntimeException("Invalid encoding 0x" + Integer.toString(encodedPoint[0], 16));
            }
        }
        return p;
    }
}

