/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.util.ecc;

import io.jafka.jeos.util.Raw;
import io.jafka.jeos.util.SHA;
import io.jafka.jeos.util.ecc.Hex;
import io.jafka.jeos.util.ecc.Point;
import io.jafka.jeos.util.ecc.Secp256k;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class Ecdsa {
    Secp256k curve = null;

    public Ecdsa(Secp256k curve) {
        this.curve = curve;
    }

    public SignBigInt sign(String dataHash, BigInteger d, int nonce) {
        BigInteger n = this.curve.n();
        SignBigInt big = new SignBigInt();
        this.deterministicGenerateK(this.curve, dataHash, d, nonce, big);
        BigInteger N_OVER_TWO = n.shiftRight(1);
        if (big.getS().compareTo(N_OVER_TWO) > 0) {
            big.setS(n.subtract(big.getS()));
        }
        big.setDer(this.toDER(big));
        return big;
    }

    private byte[] toDER(SignBigInt big) {
        int i;
        byte[] rBa = big.getR().toByteArray();
        byte[] sBa = big.getS().toByteArray();
        ArrayList<Byte> sequence = new ArrayList<Byte>();
        sequence.add(new Byte(2));
        sequence.add(new Byte((byte)rBa.length));
        for (i = 0; i < rBa.length; ++i) {
            sequence.add(rBa[i]);
        }
        sequence.add(new Byte(2));
        sequence.add(new Byte((byte)sBa.length));
        for (i = 0; i < sBa.length; ++i) {
            sequence.add(sBa[i]);
        }
        int len = sequence.size();
        sequence.add(0, (byte)48);
        sequence.add(1, (byte)len);
        byte[] bf = new byte[sequence.size()];
        for (int i2 = 0; i2 < bf.length; ++i2) {
            bf[i2] = (Byte)sequence.get(i2);
        }
        return bf;
    }

    private BigInteger deterministicGenerateK(Secp256k curve, String dataHash, BigInteger d, int nonce, SignBigInt big) {
        byte[] hash = Hex.toBytes(dataHash);
        if (nonce > 0) {
            hash = SHA.sha256(Raw.concat(hash, new byte[nonce]));
        }
        byte[] x = null;
        x = d.toByteArray()[0] == 0 ? Raw.copy(d.toByteArray(), 1, d.toByteArray().length - 1) : d.toByteArray();
        byte[] k = new byte[32];
        byte[] v = new byte[32];
        Arrays.fill(v, (byte)1);
        Arrays.fill(k, (byte)0);
        byte[] db = Raw.concat(Raw.concat(Raw.concat(v, new byte[]{0}), x), hash);
        k = SHA.hmacSha256(db, k);
        v = SHA.hmacSha256(v, k);
        byte[] fb = Raw.concat(Raw.concat(Raw.concat(v, new byte[]{1}), x), hash);
        k = SHA.hmacSha256(fb, k);
        v = SHA.hmacSha256(v, k);
        v = SHA.hmacSha256(v, k);
        BigInteger T = new BigInteger(Hex.toHex(v), 16);
        BigInteger e = new BigInteger(dataHash, 16);
        Boolean check = this.checkSig(T, d, e, big);
        while (T.signum() <= 0 || T.compareTo(curve.n()) >= 0 || !check.booleanValue()) {
            k = SHA.hmacSha256(Raw.concat(v, new byte[]{0}), k);
            v = SHA.hmacSha256(v, k);
            v = SHA.hmacSha256(v, k);
            T = new BigInteger(v);
        }
        big.setK(T);
        return T;
    }

    public Boolean checkSig(BigInteger k, BigInteger d, BigInteger e, SignBigInt big) {
        Point Q = this.curve.G().multiply(k);
        if (Q.isInfinity()) {
            return false;
        }
        BigInteger r = Q.getX().toBigInteger().mod(this.curve.n());
        big.setR(r);
        if (r.signum() == 0) {
            return false;
        }
        BigInteger s = k.modInverse(this.curve.n()).multiply(e.add(d.multiply(r))).mod(this.curve.n());
        big.setS(s);
        if (s.signum() == 0) {
            return false;
        }
        return true;
    }

    public int calcPubKeyRecoveryParam(BigInteger e, SignBigInt sign, Point Q) {
        for (int i = 0; i < 4; ++i) {
            Point Qprime = this.recoverPubKey(e, sign, i);
            if (!Qprime.equals(Q)) continue;
            return i;
        }
        throw new RuntimeException("Unable to find valid recovery factor");
    }

    public Point recoverPubKey(BigInteger e, SignBigInt big, int i) {
        BigInteger n = this.curve.n();
        Point G = this.curve.G();
        BigInteger r = big.getR();
        BigInteger s = big.getS();
        if (r.signum() <= 0 || r.compareTo(n) >= 0) {
            throw new RuntimeException("Invalid r value");
        }
        if (s.signum() <= 0 || s.compareTo(n) >= 0) {
            throw new RuntimeException("Invalid r value");
        }
        int isYOdd = i & 1;
        int isSecondKey = i >> 1;
        BigInteger x = isSecondKey == 1 ? r.add(n) : r;
        Point R = this.curve.getCurve().pointFromX(isYOdd, x);
        Point nR = R.multiply(n);
        if (!nR.isInfinity()) {
            throw new RuntimeException("nR is not a valid curve point");
        }
        BigInteger eNeg = e.negate().mod(n);
        BigInteger rInv = r.modInverse(n);
        Point Q = R.multiplyTwo(s, G, eNeg).multiply(rInv);
        if (Q.isInfinity()) {
            throw new RuntimeException("Point is at infinity");
        }
        return Q;
    }

    public static class SignBigInt {
        private BigInteger k;
        private BigInteger r;
        private BigInteger s;
        private byte[] der;

        public BigInteger getK() {
            return this.k;
        }

        public void setK(BigInteger k) {
            this.k = k;
        }

        public BigInteger getR() {
            return this.r;
        }

        public void setR(BigInteger r) {
            this.r = r;
        }

        public BigInteger getS() {
            return this.s;
        }

        public void setS(BigInteger s) {
            this.s = s;
        }

        public byte[] getDer() {
            return this.der;
        }

        public void setDer(byte[] der) {
            this.der = der;
        }
    }
}

