/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.convert;

import io.jafka.jeos.core.common.transaction.PackedTransaction;
import io.jafka.jeos.core.request.chain.json2bin.BuyRamArg;
import io.jafka.jeos.core.request.chain.json2bin.CreateAccountArg;
import io.jafka.jeos.core.request.chain.json2bin.DelegatebwArg;
import io.jafka.jeos.core.request.chain.json2bin.TransferArg;
import io.jafka.jeos.util.Raw;
import io.jafka.jeos.util.ecc.Hex;
import java.time.ZoneOffset;
import java.util.Arrays;

public class Packer {
    public static String packTransfer(TransferArg arg) {
        Raw raw = new Raw();
        raw.packName(arg.getFrom());
        raw.packName(arg.getTo());
        raw.packAsset(arg.getQuantity());
        raw.pack(arg.getMemo());
        return raw.toHex();
    }

    public static String packBuyrambytes(BuyRamArg arg) {
        Raw raw = new Raw();
        raw.packName(arg.getPayer());
        raw.packName(arg.getReceiver());
        raw.pack(arg.getBytes());
        return raw.toHex();
    }

    public static String packDelegatebw(DelegatebwArg arg) {
        Raw raw = new Raw();
        raw.packName(arg.getFrom());
        raw.packName(arg.getReceiver());
        raw.packAsset(arg.getStakeNetQuantity());
        raw.packAsset(arg.getStakeCpuQuantity());
        raw.packVarint32(arg.getTransfer());
        return raw.toHex();
    }

    public static String packCreateAccount(CreateAccountArg arg) {
        Raw raw = new Raw();
        raw.packName(arg.getCreator());
        raw.packName(arg.getName());
        Arrays.asList(arg.getOwner(), arg.getActive()).stream().filter(x -> x != null).forEach(r -> {
            raw.packUint32(r.getThreshold());
            raw.packVarint32(r.getKeys().size());
            r.getKeys().forEach(k -> {
                raw.packPublicKey(k.getKey());
                raw.packUint16(k.getWeight());
            });
            raw.packVarint32(r.getAccounts().size());
            r.getAccounts().forEach(a -> {
                raw.packName(a.getPermission().getActor());
                raw.packName(a.getPermission().getPermission());
                raw.packUint16(a.getWeight());
            });
            raw.packVarint32(r.getWaits().size());
            r.getWaits().forEach(w -> {
                raw.packUint32(w.getWeightSec());
                raw.packUint16(w.getWeight());
            });
        });
        return raw.toHex();
    }

    public static Raw packPackedTransaction(String chainId, PackedTransaction t) {
        Raw raw = new Raw();
        raw.pack(Hex.toBytes(chainId));
        raw.packUint32(t.getExpiration().toEpochSecond(ZoneOffset.ofHours(0)));
        raw.packUint16(t.getRefBlockNum().intValue());
        raw.packUint32(t.getRefBlockPrefix());
        raw.packVarint32(t.getMaxNetUsageWords().intValue());
        raw.packUint8(t.getMaxCpuUsageMs());
        raw.packVarint32(t.getDelaySec().intValue());
        raw.packVarint32(t.getContextFreeActions().size());
        raw.packVarint32(t.getActions().size());
        t.getActions().forEach(a -> {
            raw.packName(a.getAccount()).packName(a.getName()).packVarint32(a.getAuthorization().size());
            a.getAuthorization().forEach(au -> raw.packName(au.getActor()).packName(au.getPermission()));
            byte[] dat = Hex.toBytes(a.getData());
            raw.packVarint32(dat.length);
            raw.pack(dat);
        });
        return raw;
    }
}

