/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.community.ssl;

import io.javalin.Javalin;
import io.javalin.community.ssl.SSLConfig;
import io.javalin.community.ssl.util.ConnectorFactory;
import io.javalin.community.ssl.util.SSLUtils;
import io.javalin.jetty.JettyUtil;
import io.javalin.plugin.Plugin;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;

public class SSLPlugin
implements Plugin {
    private final SSLConfig config;

    public SSLPlugin() {
        this.config = new SSLConfig();
    }

    public SSLPlugin(SSLConfig config) {
        this.config = config;
    }

    public SSLPlugin(Consumer<SSLConfig> config) {
        this();
        config.accept(this.config);
    }

    public void apply(@NotNull Javalin javalin) {
        Consumer<Server> patcher = SSLPlugin.createJettyServerPatcher(this.config);
        javalin.cfg.jetty.server(() -> {
            Server server = Objects.requireNonNullElseGet(javalin.cfg.pvt.server, SSLPlugin::getServer);
            patcher.accept(server);
            return server;
        });
    }

    public void patch(@NotNull Server server) {
        Consumer<Server> patcher = SSLPlugin.createJettyServerPatcher(this.config);
        patcher.accept(server);
    }

    private static Consumer<Server> createJettyServerPatcher(SSLConfig config) {
        SslContextFactory.Server sslContextFactory;
        if (config.secure) {
            sslContextFactory = SSLUtils.createSslContextFactory(config);
        } else {
            Objects.requireNonNull(config);
            sslContextFactory = null;
        }
        return server -> {
            LinkedList<ServerConnector> connectorList = new LinkedList<ServerConnector>();
            ConnectorFactory connectorFactory = new ConnectorFactory(config, (Server)server, sslContextFactory);
            if (config.insecure) {
                connectorList.add(connectorFactory.createInsecureConnector());
            }
            if (config.secure) {
                connectorList.add(connectorFactory.createSecureConnector());
            }
            Objects.requireNonNull(config);
            connectorList.forEach(arg_0 -> ((Server)server).addConnector(arg_0));
        };
    }

    private static Server getServer() {
        return JettyUtil.getOrDefault(null);
    }
}

