/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.community.ssl.util;

import io.javalin.community.ssl.SSLConfig;
import io.javalin.community.ssl.SSLConfigException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.util.JettySslUtils;
import nl.altindag.ssl.util.PemUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLUtils {
    public static SslContextFactory.Server createSslContextFactory(SSLConfig config) {
        SSLFactory.Builder builder = SSLFactory.builder();
        SSLUtils.parseIdentity(config, builder);
        builder.withSecurityProvider(config.securityProvider);
        builder.withCiphers(config.tlsConfig.getCipherSuites());
        builder.withProtocols(config.tlsConfig.getProtocols());
        SSLFactory sslFactory = builder.build();
        return JettySslUtils.forServer((SSLFactory)sslFactory);
    }

    public static void parseIdentity(SSLConfig config, SSLFactory.Builder builder) throws SSLConfigException {
        X509ExtendedKeyManager keyManager;
        SSLConfig.InnerConfig.IdentityLoadingType identityLoadingType = config.inner.getIdentityLoadingType();
        boolean passwordProtectedPem = config.inner.privateKeyPassword != null;
        switch (identityLoadingType) {
            case PEM_FILE_PATH: {
                keyManager = passwordProtectedPem ? PemUtils.loadIdentityMaterial((Path)config.inner.pemCertificatesPath, (Path)config.inner.pemPrivateKeyPath, (char[])config.inner.privateKeyPassword.toCharArray()) : PemUtils.loadIdentityMaterial((Path)config.inner.pemCertificatesPath, (Path)config.inner.pemPrivateKeyPath);
                break;
            }
            case PEM_CLASS_PATH: {
                keyManager = passwordProtectedPem ? PemUtils.loadIdentityMaterial((String)config.inner.pemCertificatesFile, (String)config.inner.pemPrivateKeyFile, (char[])config.inner.privateKeyPassword.toCharArray()) : PemUtils.loadIdentityMaterial((String)config.inner.pemCertificatesFile, (String)config.inner.pemPrivateKeyFile);
                break;
            }
            case PEM_STRING: {
                keyManager = passwordProtectedPem ? PemUtils.parseIdentityMaterial((String)config.inner.pemCertificatesString, (String)config.inner.pemPrivateKeyString, (char[])config.inner.privateKeyPassword.toCharArray()) : PemUtils.parseIdentityMaterial((String)config.inner.pemCertificatesString, (String)config.inner.pemPrivateKeyString, null);
                break;
            }
            case PEM_INPUT_STREAM: {
                keyManager = passwordProtectedPem ? PemUtils.loadIdentityMaterial((InputStream)config.inner.pemCertificatesInputStream, (InputStream)config.inner.pemPrivateKeyInputStream, (char[])config.inner.privateKeyPassword.toCharArray()) : PemUtils.loadIdentityMaterial((InputStream)config.inner.pemCertificatesInputStream, (InputStream)config.inner.pemPrivateKeyInputStream);
                break;
            }
            case KEY_STORE_CLASS_PATH: {
                builder.withIdentityMaterial(config.inner.keyStoreFile, config.inner.keyStorePassword.toCharArray());
                return;
            }
            case KEY_STORE_FILE_PATH: {
                builder.withIdentityMaterial(config.inner.keyStorePath, config.inner.keyStorePassword.toCharArray());
                return;
            }
            case KEY_STORE_INPUT_STREAM: {
                builder.withIdentityMaterial(config.inner.keyStoreInputStream, config.inner.keyStorePassword.toCharArray());
                return;
            }
            default: {
                throw new SSLConfigException(SSLConfigException.Types.MISSING_CERT_AND_KEY_FILE);
            }
        }
        builder.withIdentityMaterial((X509KeyManager)keyManager);
    }
}

