/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.community.ssl;

import io.javalin.community.ssl.SslConfig;
import io.javalin.community.ssl.util.ConnectorFactory;
import io.javalin.community.ssl.util.SSLUtils;
import io.javalin.config.JavalinConfig;
import io.javalin.config.JettyConfig;
import io.javalin.plugin.Plugin;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.util.SSLFactoryUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n0\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/javalin/community/ssl/SslPlugin;", "Lio/javalin/plugin/Plugin;", "Lio/javalin/community/ssl/SslConfig;", "userConfig", "Ljava/util/function/Consumer;", "(Ljava/util/function/Consumer;)V", "sslFactory", "Lnl/altindag/ssl/SSLFactory;", "createConnectors", "", "Ljava/util/function/BiFunction;", "Lorg/eclipse/jetty/server/Server;", "Lorg/eclipse/jetty/server/HttpConfiguration;", "Lorg/eclipse/jetty/server/Connector;", "config", "name", "", "onStart", "", "Lio/javalin/config/JavalinConfig;", "reload", "newConfig", "ssl-plugin"})
@SourceDebugExtension(value={"SMAP\nSslPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SslPlugin.kt\nio/javalin/community/ssl/SslPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1855#2,2:81\n1#3:83\n*S KotlinDebug\n*F\n+ 1 SslPlugin.kt\nio/javalin/community/ssl/SslPlugin\n*L\n30#1:81,2\n*E\n"})
public final class SslPlugin
extends Plugin<SslConfig> {
    @Nullable
    private SSLFactory sslFactory;

    public SslPlugin(@NotNull Consumer<SslConfig> userConfig) {
        Intrinsics.checkNotNullParameter(userConfig, (String)"userConfig");
        super(userConfig, (Object)new SslConfig());
    }

    /*
     * WARNING - void declaration
     */
    public void onStart(@NotNull JavalinConfig config) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Iterable iterable = this.createConnectors((SslConfig)this.pluginConfig);
        JettyConfig jettyConfig = config.jetty;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BiFunction p0 = (BiFunction)element$iv;
            boolean bl = false;
            jettyConfig.addConnector(p0);
        }
        if (((SslConfig)this.pluginConfig).redirect && ((SslConfig)this.pluginConfig).secure) {
            config.jetty.modifyServer(SslPlugin::onStart$lambda$0);
        }
    }

    @NotNull
    public String name() {
        return "SSL Plugin";
    }

    public final void reload(@NotNull Consumer<SslConfig> newConfig) {
        Intrinsics.checkNotNullParameter(newConfig, (String)"newConfig");
        SslConfig conf = new SslConfig();
        newConfig.accept(conf);
        if (this.sslFactory == null) {
            boolean bl = false;
            String string = "Cannot reload before the plugin has been applied to a Javalin instance, a server has been patched or if the ssl connector is disabled.";
            throw new IllegalStateException(string.toString());
        }
        SSLFactory newFactory = SSLUtils.INSTANCE.getSslFactory(conf, true);
        SSLFactoryUtils.reload((SSLFactory)this.sslFactory, (SSLFactory)newFactory);
    }

    private final List<BiFunction<Server, HttpConfiguration, Connector>> createConnectors(SslConfig config) {
        SslContextFactory.Server sslContextFactory = null;
        if (config.secure) {
            this.sslFactory = SSLUtils.INSTANCE.getSslFactory(config);
            sslContextFactory = SSLUtils.INSTANCE.createSslContextFactory(this.sslFactory);
        } else {
            sslContextFactory = null;
        }
        ArrayList<BiFunction<Server, HttpConfiguration, Connector>> connectorList = new ArrayList<BiFunction<Server, HttpConfiguration, Connector>>();
        ConnectorFactory connectorFactory = new ConnectorFactory(config, sslContextFactory);
        if (config.insecure) {
            connectorList.add(connectorFactory::createInsecureConnector);
        }
        if (config.secure) {
            connectorList.add(connectorFactory::createSecureConnector);
        }
        return connectorList;
    }

    private static final void onStart$lambda$0(Server it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setHandler((Handler)new SecuredRedirectHandler());
    }
}

