/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.mock.servlet;

import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/javalin/mock/servlet/InMemoryPart;", "Ljakarta/servlet/http/Part;", "state", "Lio/javalin/mock/servlet/InMemoryPart$PartState;", "(Lio/javalin/mock/servlet/InMemoryPart$PartState;)V", "delete", "", "getContentType", "", "getHeader", "name", "getHeaderNames", "", "getHeaders", "getInputStream", "Ljava/io/InputStream;", "getName", "getSize", "", "getSubmittedFileName", "write", "fileName", "PartState", "javalin-context-mock"})
public final class InMemoryPart
implements Part {
    @NotNull
    private final PartState state;

    public InMemoryPart(@NotNull PartState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @NotNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.state.content);
    }

    @NotNull
    public String getContentType() {
        return this.state.contentType;
    }

    @NotNull
    public String getName() {
        return this.state.name;
    }

    @NotNull
    public String getSubmittedFileName() {
        return this.state.fileName;
    }

    public long getSize() {
        return this.state.size;
    }

    public void write(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Files.write(Paths.get(fileName, new String[0]), this.state.content, new OpenOption[0]);
    }

    public void delete() {
    }

    @Nullable
    public String getHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<String> list = this.state.headers.get(name);
        return list != null ? (String)CollectionsKt.firstOrNull(list) : null;
    }

    @NotNull
    public Collection<String> getHeaders(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<String> list = this.state.headers.get(name);
        return list != null ? (Collection)list : (Collection)CollectionsKt.emptyList();
    }

    @NotNull
    public Collection<String> getHeaderNames() {
        return this.state.headers.keySet();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b\u00a2\u0006\u0002\u0010\rR\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/javalin/mock/servlet/InMemoryPart$PartState;", "", "name", "", "fileName", "content", "", "size", "", "contentType", "headers", "", "", "(Ljava/lang/String;Ljava/lang/String;[BJLjava/lang/String;Ljava/util/Map;)V", "javalin-context-mock"})
    public static final class PartState {
        @JvmField
        @NotNull
        public final String name;
        @JvmField
        @NotNull
        public final String fileName;
        @JvmField
        @NotNull
        public final byte[] content;
        @JvmField
        public final long size;
        @JvmField
        @NotNull
        public final String contentType;
        @JvmField
        @NotNull
        public final Map<String, List<String>> headers;

        @JvmOverloads
        public PartState(@NotNull String name, @NotNull String fileName, @NotNull byte[] content, long size, @NotNull String contentType, @NotNull Map<String, ? extends List<String>> headers) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            this.name = name;
            this.fileName = fileName;
            this.content = content;
            this.size = size;
            this.contentType = contentType;
            this.headers = headers;
        }

        public /* synthetic */ PartState(String string, String string2, byte[] byArray, long l, String string3, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                l = byArray.length;
            }
            if ((n & 0x10) != 0) {
                string3 = "application/octet-stream";
            }
            if ((n & 0x20) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, string2, byArray, l, string3, map);
        }

        @JvmOverloads
        public PartState(@NotNull String name, @NotNull String fileName, @NotNull byte[] content, long size, @NotNull String contentType) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            this(name, fileName, content, size, contentType, null, 32, null);
        }

        @JvmOverloads
        public PartState(@NotNull String name, @NotNull String fileName, @NotNull byte[] content, long size) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this(name, fileName, content, size, null, null, 48, null);
        }

        @JvmOverloads
        public PartState(@NotNull String name, @NotNull String fileName, @NotNull byte[] content) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this(name, fileName, content, 0L, null, null, 56, null);
        }
    }
}

