/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.micrometer;

import io.javalin.Javalin;
import io.javalin.event.EventListener;
import io.javalin.http.Context;
import io.javalin.http.ExceptionHandler;
import io.javalin.http.HandlerType;
import io.javalin.http.HttpStatus;
import io.javalin.jetty.JettyServer;
import io.javalin.micrometer.MicrometerConfig;
import io.javalin.micrometer.MicrometerPlugin;
import io.javalin.plugin.Plugin;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.http.DefaultHttpJakartaServletRequestTagsProvider;
import io.micrometer.core.instrument.binder.http.HttpJakartaServletRequestTagsProvider;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettyServerThreadPoolMetrics;
import io.micrometer.jetty11.TimedHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/javalin/micrometer/MicrometerPlugin;", "Lio/javalin/plugin/Plugin;", "registry", "Lio/micrometer/core/instrument/MeterRegistry;", "tags", "", "Lio/micrometer/core/instrument/Tag;", "tagExceptionName", "", "tagRedirectPaths", "tagNotFoundMappedPaths", "(Lio/micrometer/core/instrument/MeterRegistry;Ljava/lang/Iterable;ZZZ)V", "apply", "", "app", "Lio/javalin/Javalin;", "prefixIfNot", "", "prefix", "Companion", "javalin-micrometer"})
@SourceDebugExtension(value={"SMAP\nMicrometerPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicrometerPlugin.kt\nio/javalin/micrometer/MicrometerPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class MicrometerPlugin
implements Plugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MeterRegistry registry;
    @NotNull
    private final Iterable<Tag> tags;
    private final boolean tagExceptionName;
    private final boolean tagRedirectPaths;
    private final boolean tagNotFoundMappedPaths;
    @NotNull
    private static final String EXCEPTION_HEADER = "__micrometer_exception_name";
    @JvmField
    @NotNull
    public static ExceptionHandler<Exception> exceptionHandler = MicrometerPlugin::exceptionHandler$lambda$4;
    @NotNull
    private static ExceptionHandler<Exception> EXCEPTION_HANDLER = exceptionHandler;

    private MicrometerPlugin(MeterRegistry registry, Iterable<? extends Tag> tags, boolean tagExceptionName, boolean tagRedirectPaths, boolean tagNotFoundMappedPaths) {
        this.registry = registry;
        this.tags = tags;
        this.tagExceptionName = tagExceptionName;
        this.tagRedirectPaths = tagRedirectPaths;
        this.tagNotFoundMappedPaths = tagNotFoundMappedPaths;
    }

    public void apply(@NotNull Javalin app) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            JettyServer jettyServer = app.jettyServer();
            if (jettyServer == null || (jettyServer = jettyServer.server()) == null) break block1;
            JettyServer server = jettyServer;
            boolean bl = false;
            if (this.tagExceptionName) {
                app.exception(Exception.class, exceptionHandler);
            }
            server.insertHandler((HandlerWrapper)new TimedHandler(this.registry, this.tags, (HttpJakartaServletRequestTagsProvider)new DefaultHttpJakartaServletRequestTagsProvider(this, app){
                final /* synthetic */ MicrometerPlugin this$0;
                final /* synthetic */ Javalin $app;
                {
                    this.this$0 = $receiver;
                    this.$app = $app;
                }

                @NotNull
                public Iterable<Tag> getTags(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    String exceptionName = MicrometerPlugin.access$getTagExceptionName$p(this.this$0) ? response.getHeader("__micrometer_exception_name") : "Unknown";
                    String string = request.getPathInfo();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.pathInfo");
                    String pathInfo = MicrometerPlugin.access$prefixIfNot(this.this$0, StringsKt.removePrefix((String)string, (CharSequence)this.$app.cfg.routing.contextPath), "/");
                    response.setHeader("__micrometer_exception_name", null);
                    String string2 = request.getMethod();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.method");
                    HandlerType handlerType = HandlerType.valueOf((String)string2);
                    String string3 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.$app.javalinServlet().getMatcher().findEntries(handlerType, pathInfo)), (Function1)apply.1.getTags.uri.1.INSTANCE), (Function1)apply.1.getTags.uri.2.INSTANCE), (Function1)((Function1)new Function1<String, String>(this.this$0, response){
                        final /* synthetic */ MicrometerPlugin this$0;
                        final /* synthetic */ HttpServletResponse $response;
                        {
                            this.this$0 = $receiver;
                            this.$response = $response;
                            super(1);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @NotNull
                        public final String invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (!MicrometerPlugin.access$getTagRedirectPaths$p(this.this$0)) {
                                boolean bl;
                                int n = this.$response.getStatus();
                                if (300 <= n) {
                                    if (n < 400) {
                                        return "REDIRECTION";
                                    }
                                    bl = false;
                                } else {
                                    bl = false;
                                }
                                if (bl) {
                                    return "REDIRECTION";
                                }
                            }
                            String string = it;
                            return string;
                        }
                    })), (Function1)((Function1)new Function1<String, String>(this.this$0, response){
                        final /* synthetic */ MicrometerPlugin this$0;
                        final /* synthetic */ HttpServletResponse $response;
                        {
                            this.this$0 = $receiver;
                            this.$response = $response;
                            super(1);
                        }

                        @NotNull
                        public final String invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return !MicrometerPlugin.access$getTagNotFoundMappedPaths$p(this.this$0) && this.$response.getStatus() == 404 ? "NOT_FOUND" : it;
                        }
                    })));
                    if (string3 == null) {
                        string3 = "NOT_FOUND";
                    }
                    String uri2 = string3;
                    Iterable iterable = super.getTags(request, response);
                    String[] stringArray = new String[4];
                    stringArray[0] = "uri";
                    stringArray[1] = uri2;
                    stringArray[2] = "exception";
                    String string4 = exceptionName;
                    if (string4 == null) {
                        string4 = "None";
                    }
                    stringArray[3] = string4;
                    Tags tags = Tags.concat((Iterable)iterable, (String[])stringArray);
                    Intrinsics.checkNotNullExpressionValue((Object)tags, (String)"concat(\n                \u2026ne\"\n                    )");
                    return (Iterable)tags;
                }
            }));
            new JettyServerThreadPoolMetrics(server.getThreadPool(), this.tags).bindTo(this.registry);
            app.events(arg_0 -> MicrometerPlugin.apply$lambda$2$lambda$1((Server)server, this, arg_0));
        }
    }

    private final String prefixIfNot(String $this$prefixIfNot, String prefix) {
        return StringsKt.startsWith$default((String)$this$prefixIfNot, (String)prefix, (boolean)false, (int)2, null) ? $this$prefixIfNot : prefix + $this$prefixIfNot;
    }

    private static final void apply$lambda$2$lambda$1$lambda$0(Server $server, MicrometerPlugin this$0) {
        Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JettyConnectionMetrics.addToAllConnectors((Server)$server, (MeterRegistry)this$0.registry, this$0.tags);
    }

    private static final void apply$lambda$2$lambda$1(Server $server, MicrometerPlugin this$0, EventListener it) {
        Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.serverStarted(() -> MicrometerPlugin.apply$lambda$2$lambda$1$lambda$0($server, this$0));
    }

    private static final void exceptionHandler$lambda$4(Exception e, Context ctx) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String simpleName = e.getClass().getSimpleName();
        Context context = ctx;
        String string = EXCEPTION_HEADER;
        CharSequence charSequence2 = simpleName;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            String string2 = string;
            Context context2 = context;
            boolean bl = false;
            String string3 = e.getClass().getName();
            context = context2;
            string = string2;
            charSequence = string3;
        } else {
            charSequence = charSequence2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"simpleName.ifBlank { e.javaClass.name }");
        context.header(string, (String)charSequence);
        ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @JvmStatic
    @NotNull
    public static final MicrometerPlugin create(@NotNull Consumer<MicrometerConfig> userConfig) {
        return Companion.create(userConfig);
    }

    public /* synthetic */ MicrometerPlugin(MeterRegistry registry, Iterable tags, boolean tagExceptionName, boolean tagRedirectPaths, boolean tagNotFoundMappedPaths, DefaultConstructorMarker $constructor_marker) {
        this(registry, tags, tagExceptionName, tagRedirectPaths, tagNotFoundMappedPaths);
    }

    public static final /* synthetic */ boolean access$getTagExceptionName$p(MicrometerPlugin $this) {
        return $this.tagExceptionName;
    }

    public static final /* synthetic */ String access$prefixIfNot(MicrometerPlugin $this, String $receiver, String prefix) {
        return $this.prefixIfNot($receiver, prefix);
    }

    public static final /* synthetic */ boolean access$getTagRedirectPaths$p(MicrometerPlugin $this) {
        return $this.tagRedirectPaths;
    }

    public static final /* synthetic */ boolean access$getTagNotFoundMappedPaths$p(MicrometerPlugin $this) {
        return $this.tagNotFoundMappedPaths;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007R*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/javalin/micrometer/MicrometerPlugin$Companion;", "", "()V", "EXCEPTION_HANDLER", "Lio/javalin/http/ExceptionHandler;", "Ljava/lang/Exception;", "getEXCEPTION_HANDLER$annotations", "getEXCEPTION_HANDLER", "()Lio/javalin/http/ExceptionHandler;", "setEXCEPTION_HANDLER", "(Lio/javalin/http/ExceptionHandler;)V", "EXCEPTION_HEADER", "", "exceptionHandler", "create", "Lio/javalin/micrometer/MicrometerPlugin;", "userConfig", "Ljava/util/function/Consumer;", "Lio/javalin/micrometer/MicrometerConfig;", "javalin-micrometer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExceptionHandler<Exception> getEXCEPTION_HANDLER() {
            return EXCEPTION_HANDLER;
        }

        public final void setEXCEPTION_HANDLER(@NotNull ExceptionHandler<Exception> exceptionHandler) {
            Intrinsics.checkNotNullParameter(exceptionHandler, (String)"<set-?>");
            EXCEPTION_HANDLER = exceptionHandler;
        }

        @Deprecated(message="User exceptionHandler instead", replaceWith=@ReplaceWith(expression="exceptionHandler", imports={}), level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getEXCEPTION_HANDLER$annotations() {
        }

        @JvmStatic
        @NotNull
        public final MicrometerPlugin create(@NotNull Consumer<MicrometerConfig> userConfig) {
            Intrinsics.checkNotNullParameter(userConfig, (String)"userConfig");
            MicrometerConfig finalConfig = new MicrometerConfig(null, null, false, false, false, 31, null);
            userConfig.accept(finalConfig);
            return new MicrometerPlugin(finalConfig.registry, finalConfig.tags, finalConfig.tagExceptionName, finalConfig.tagRedirectPaths, finalConfig.tagNotFoundMappedPaths, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

