/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin.openapi;

import io.javalin.Javalin;
import io.javalin.core.plugin.Plugin;
import io.javalin.core.plugin.PluginLifecycleInit;
import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.Util;
import io.javalin.http.Handler;
import io.javalin.plugin.openapi.OpenApiHandler;
import io.javalin.plugin.openapi.OpenApiOptions;
import io.javalin.plugin.openapi.ui.OpenApiUiOptions;
import io.javalin.plugin.openapi.ui.ReDocRenderer;
import io.javalin.plugin.openapi.ui.SwaggerOptions;
import io.javalin.plugin.openapi.ui.SwaggerRenderer;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lio/javalin/plugin/openapi/OpenApiPlugin;", "Lio/javalin/core/plugin/Plugin;", "Lio/javalin/core/plugin/PluginLifecycleInit;", "options", "", "Lio/javalin/plugin/openapi/OpenApiOptions;", "([Lio/javalin/plugin/openapi/OpenApiOptions;)V", "handlerMap", "", "", "Lio/javalin/plugin/openapi/OpenApiHandler;", "openApiHandler", "getOpenApiHandler", "()Lio/javalin/plugin/openapi/OpenApiHandler;", "setOpenApiHandler", "(Lio/javalin/plugin/openapi/OpenApiHandler;)V", "[Lio/javalin/plugin/openapi/OpenApiOptions;", "apply", "", "app", "Lio/javalin/Javalin;", "init", "javalin-openapi"})
public final class OpenApiPlugin
implements Plugin,
PluginLifecycleInit {
    @NotNull
    public OpenApiHandler openApiHandler;
    private final Map<String, OpenApiHandler> handlerMap;
    private final OpenApiOptions[] options;

    @NotNull
    public final OpenApiHandler getOpenApiHandler() {
        OpenApiHandler openApiHandler = this.openApiHandler;
        if (openApiHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"openApiHandler");
        }
        return openApiHandler;
    }

    public final void setOpenApiHandler(@NotNull OpenApiHandler openApiHandler) {
        Intrinsics.checkParameterIsNotNull((Object)openApiHandler, (String)"<set-?>");
        this.openApiHandler = openApiHandler;
    }

    public void init(@NotNull Javalin app) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        OpenApiOptions[] openApiOptionsArray = this.options;
        boolean bl = false;
        if (openApiOptionsArray.length == 0) {
            throw (Throwable)new IllegalArgumentException("The OpenApiPlugin requires at least one set of Options");
        }
        this.openApiHandler = new OpenApiHandler(app, (OpenApiOptions)ArraysKt.first((Object[])this.options));
        OpenApiOptions[] $this$forEach$iv = this.options;
        boolean $i$f$forEach = false;
        OpenApiOptions[] openApiOptionsArray2 = $this$forEach$iv;
        int n = openApiOptionsArray2.length;
        for (int i = 0; i < n; ++i) {
            String string;
            OpenApiOptions element$iv;
            OpenApiOptions it = element$iv = openApiOptionsArray2[i];
            boolean bl2 = false;
            if (it.getPath() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String path = string;
            boolean bl5 = false;
            this.handlerMap.putIfAbsent(path, new OpenApiHandler(app, it));
        }
    }

    public void apply(@NotNull Javalin app) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Util.ensureDependencyPresent$default((Util)Util.INSTANCE, (OptionalDependency)OptionalDependency.SWAGGER_CORE, (boolean)false, (int)2, null);
        OpenApiOptions[] $this$forEach$iv = this.options;
        boolean $i$f$forEach = false;
        OpenApiOptions[] openApiOptionsArray = $this$forEach$iv;
        int n = openApiOptionsArray.length;
        for (int i = 0; i < n; ++i) {
            SwaggerOptions it;
            OpenApiUiOptions openApiUiOptions;
            boolean bl;
            boolean bl2;
            String string;
            OpenApiOptions element$iv;
            OpenApiOptions options = element$iv = openApiOptionsArray[i];
            boolean bl3 = false;
            if (options.getPath() == null && (options.getSwagger() != null || options.getReDoc() != null)) {
                throw (Throwable)new IllegalStateException(StringsKt.replace$default((String)"Swagger or ReDoc is enabled, but there is no endpoint available for the OpenApi schema.\nPlease use the `path` option of the OpenApiPlugin to set a schema endpoint.", (String)"\n", (String)" ", (boolean)false, (int)4, null));
            }
            if (options.getPath() == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            String path = string;
            boolean bl6 = false;
            OpenApiHandler openApiHandler = this.handlerMap.get(path);
            if (openApiHandler == null) {
                Intrinsics.throwNpe();
            }
            app.get(path, (Handler)openApiHandler, options.getRoles());
            if (options.getSwagger() != null) {
                bl2 = false;
                bl = false;
                it = openApiUiOptions;
                boolean bl7 = false;
                Util.assertWebjarInstalled((OptionalDependency)OptionalDependency.SWAGGERUI);
                app.get(it.getPath(), (Handler)new SwaggerRenderer(options), options.getRoles());
            }
            if (options.getReDoc() != null) {
                bl2 = false;
                bl = false;
                it = openApiUiOptions;
                boolean bl8 = false;
                Util.assertWebjarInstalled((OptionalDependency)OptionalDependency.REDOC);
                app.get(it.getPath(), (Handler)new ReDocRenderer(options), options.getRoles());
            }
            if (options.getSwagger() == null && options.getReDoc() == null) continue;
            app.config.enableWebjars();
        }
    }

    public OpenApiPlugin(OpenApiOptions ... options) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.options = options;
        OpenApiPlugin openApiPlugin = this;
        boolean bl = false;
        openApiPlugin.handlerMap = map = (Map)new LinkedHashMap();
    }
}

