/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin.openapi.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lio/javalin/plugin/openapi/jackson/JavalinModelResolver;", "Lio/swagger/v3/core/jackson/ModelResolver;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "extractJavaType", "Lcom/fasterxml/jackson/databind/JavaType;", "annotatedType", "Lio/swagger/v3/core/converter/AnnotatedType;", "resolve", "Lio/swagger/v3/oas/models/media/Schema;", "context", "Lio/swagger/v3/core/converter/ModelConverterContext;", "next", "", "Lio/swagger/v3/core/converter/ModelConverter;", "javalin-openapi"})
public final class JavalinModelResolver
extends ModelResolver {
    @NotNull
    public Schema<?> resolve(@Nullable AnnotatedType annotatedType, @Nullable ModelConverterContext context, @Nullable Iterator<? extends ModelConverter> next) {
        if (annotatedType == null || this.shouldIgnoreClass(annotatedType.getType())) {
            Schema schema2 = super.resolve(annotatedType, context, next);
            Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"super.resolve(annotatedType, context, next)");
            return schema2;
        }
        JavaType type = this.extractJavaType(annotatedType);
        if (type.isTypeOrSubTypeOf(Instant.class) && this._mapper.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            Schema schema3 = PrimitiveType.LONG.createProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)schema3, (String)"PrimitiveType.LONG.createProperty()");
            return schema3;
        }
        Schema schema4 = super.resolve(annotatedType, context, next);
        Intrinsics.checkExpressionValueIsNotNull((Object)schema4, (String)"super.resolve(annotatedType, context, next)");
        return schema4;
    }

    private final JavaType extractJavaType(AnnotatedType annotatedType) {
        JavaType javaType;
        if (annotatedType.getType() instanceof JavaType) {
            Type type = annotatedType.getType();
            if (type == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.JavaType");
            }
            javaType = (JavaType)type;
        } else {
            JavaType javaType2 = this._mapper.constructType(annotatedType.getType());
            javaType = javaType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaType2, (String)"this._mapper.constructType(annotatedType.type)");
        }
        return javaType;
    }

    public JavalinModelResolver(@NotNull ObjectMapper mapper) {
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        super(mapper);
    }
}

