/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.rendering.markdown;

import io.javalin.http.Context;
import io.javalin.rendering.FileRenderer;
import io.javalin.rendering.JavalinRenderer;
import io.javalin.rendering.util.RenderingDependency;
import io.javalin.rendering.util.Util;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/javalin/rendering/markdown/JavalinCommonmark;", "Lio/javalin/rendering/FileRenderer;", "renderer", "Lorg/commonmark/renderer/html/HtmlRenderer;", "parser", "Lorg/commonmark/parser/Parser;", "(Lorg/commonmark/renderer/html/HtmlRenderer;Lorg/commonmark/parser/Parser;)V", "render", "", "filePath", "model", "", "", "ctx", "Lio/javalin/http/Context;", "Companion", "javalin-rendering"})
public final class JavalinCommonmark
implements FileRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HtmlRenderer renderer;
    @NotNull
    private Parser parser;

    public JavalinCommonmark(@NotNull HtmlRenderer renderer, @NotNull Parser parser) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.renderer = renderer;
        this.parser = parser;
    }

    @NotNull
    public String render(@NotNull String filePath, @NotNull Map<String, ? extends Object> model, @Nullable Context ctx) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        URL uRL = JavalinCommonmark.class.getResource(filePath);
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"JavalinCommonmark::class\u2026ava.getResource(filePath)");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String fileContent = new String(byArray, charset);
        String string = this.renderer.render(this.parser.parse(fileContent));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"renderer.render(parser.parse(fileContent))");
        return string;
    }

    @JvmStatic
    public static final void init(@Nullable HtmlRenderer htmlRenderer, @Nullable Parser parser) {
        Companion.init(htmlRenderer, parser);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lio/javalin/rendering/markdown/JavalinCommonmark$Companion;", "", "()V", "defaultParser", "Lorg/commonmark/parser/Parser;", "defaultRenderer", "Lorg/commonmark/renderer/html/HtmlRenderer;", "init", "", "htmlRenderer", "parser", "javalin-rendering"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void init(@Nullable HtmlRenderer htmlRenderer, @Nullable Parser parser) {
            Parser parser2;
            Util.INSTANCE.throwIfNotAvailable(RenderingDependency.COMMONMARK);
            HtmlRenderer htmlRenderer2 = htmlRenderer;
            if (htmlRenderer2 == null) {
                htmlRenderer2 = this.defaultRenderer();
            }
            if ((parser2 = parser) == null) {
                parser2 = this.defaultParser();
            }
            JavalinCommonmark fileRenderer = new JavalinCommonmark(htmlRenderer2, parser2);
            String[] stringArray = new String[]{".md", ".markdown"};
            JavalinRenderer.register((FileRenderer)fileRenderer, (String[])stringArray);
        }

        public static /* synthetic */ void init$default(Companion companion, HtmlRenderer htmlRenderer, Parser parser, int n, Object object) {
            if ((n & 1) != 0) {
                htmlRenderer = null;
            }
            if ((n & 2) != 0) {
                parser = null;
            }
            companion.init(htmlRenderer, parser);
        }

        @NotNull
        public final HtmlRenderer defaultRenderer() {
            HtmlRenderer htmlRenderer = HtmlRenderer.builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)htmlRenderer, (String)"builder().build()");
            return htmlRenderer;
        }

        @NotNull
        public final Parser defaultParser() {
            Parser parser = Parser.builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"builder().build()");
            return parser;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

