/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.rendering.markdown;

import io.javalin.http.Context;
import io.javalin.rendering.FileRenderer;
import io.javalin.rendering.util.RenderingDependency;
import io.javalin.rendering.util.Util;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/javalin/rendering/markdown/JavalinCommonmark;", "Lio/javalin/rendering/FileRenderer;", "renderer", "Lorg/commonmark/renderer/html/HtmlRenderer;", "parser", "Lorg/commonmark/parser/Parser;", "(Lorg/commonmark/renderer/html/HtmlRenderer;Lorg/commonmark/parser/Parser;)V", "render", "", "filePath", "model", "", "", "context", "Lio/javalin/http/Context;", "Companion", "javalin-rendering"})
public final class JavalinCommonmark
implements FileRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HtmlRenderer renderer;
    @NotNull
    private Parser parser;

    @JvmOverloads
    public JavalinCommonmark(@NotNull HtmlRenderer renderer, @NotNull Parser parser) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.renderer = renderer;
        this.parser = parser;
        Util.INSTANCE.throwIfNotAvailable(RenderingDependency.COMMONMARK);
    }

    public /* synthetic */ JavalinCommonmark(HtmlRenderer htmlRenderer, Parser parser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            htmlRenderer = Companion.defaultRenderer();
        }
        if ((n & 2) != 0) {
            parser = Companion.defaultParser();
        }
        this(htmlRenderer, parser);
    }

    @NotNull
    public String render(@NotNull String filePath, @NotNull Map<String, ? extends Object> model, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        URL uRL = JavalinCommonmark.class.getResource(filePath);
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getResource(...)");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String fileContent = new String(byArray, charset);
        String string = this.renderer.render(this.parser.parse(fileContent));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
        return string;
    }

    @JvmOverloads
    public JavalinCommonmark(@NotNull HtmlRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this(renderer, null, 2, null);
    }

    @JvmOverloads
    public JavalinCommonmark() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/javalin/rendering/markdown/JavalinCommonmark$Companion;", "", "()V", "defaultParser", "Lorg/commonmark/parser/Parser;", "defaultRenderer", "Lorg/commonmark/renderer/html/HtmlRenderer;", "javalin-rendering"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HtmlRenderer defaultRenderer() {
            HtmlRenderer htmlRenderer = HtmlRenderer.builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)htmlRenderer, (String)"build(...)");
            return htmlRenderer;
        }

        @NotNull
        public final Parser defaultParser() {
            Parser parser = Parser.builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"build(...)");
            return parser;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

