/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.testtools;

import io.javalin.Javalin;
import io.javalin.config.Key;
import io.javalin.http.Context;
import io.javalin.testtools.HttpClient;
import io.javalin.testtools.Request;
import io.javalin.testtools.TestCase;
import io.javalin.testtools.TestConfig;
import io.javalin.util.JavalinLogger;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/javalin/testtools/TestTool;", "", "testConfig", "Lio/javalin/testtools/TestConfig;", "<init>", "(Lio/javalin/testtools/TestConfig;)V", "test", "", "app", "Lio/javalin/Javalin;", "config", "testCase", "Lio/javalin/testtools/TestCase;", "captureStdOut", "", "runnable", "Ljava/lang/Runnable;", "runAndCaptureLogs", "Lio/javalin/testtools/TestTool$RunResult;", "testCode", "Companion", "RunResult", "javalin-testtools"})
@SourceDebugExtension(value={"SMAP\nTestTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestTool.kt\nio/javalin/testtools/TestTool\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,88:1\n216#2,2:89\n*S KotlinDebug\n*F\n+ 1 TestTool.kt\nio/javalin/testtools/TestTool\n*L\n46#1:89,2\n*E\n"})
public final class TestTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestConfig testConfig;
    @JvmField
    @NotNull
    public static final Key<String> TestLogsKey = new Key("testlogs");

    public TestTool(@NotNull TestConfig testConfig) {
        Intrinsics.checkNotNullParameter((Object)testConfig, (String)"testConfig");
        this.testConfig = testConfig;
    }

    public /* synthetic */ TestTool(TestConfig testConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            testConfig = new TestConfig(false, false, null, null, 15, null);
        }
        this(testConfig);
    }

    @JvmOverloads
    public final void test(@NotNull Javalin app, @NotNull TestConfig config, @NotNull TestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        RunResult result = this.runAndCaptureLogs(config, () -> TestTool.test$lambda$0(app, config, testCase));
        app.unsafe.appData(TestLogsKey, (Object)result.getLogs());
        if (result.getException() != null) {
            JavalinLogger.error$default((String)("JavalinTest#test failed - full log output below:\n" + result.getLogs()), null, (int)2, null);
            throw result.getException();
        }
    }

    public static /* synthetic */ void test$default(TestTool testTool, Javalin javalin, TestConfig testConfig, TestCase testCase, int n, Object object) {
        if ((n & 1) != 0) {
            Javalin javalin2 = Javalin.create();
            Intrinsics.checkNotNullExpressionValue((Object)javalin2, (String)"create(...)");
            javalin = javalin2;
        }
        if ((n & 2) != 0) {
            testConfig = testTool.testConfig;
        }
        testTool.test(javalin, testConfig, testCase);
    }

    @Nullable
    public final String captureStdOut(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return this.runAndCaptureLogs(this.testConfig, runnable).getLogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RunResult runAndCaptureLogs(TestConfig testConfig, Runnable testCode) {
        Throwable exception = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        if (testConfig.getCaptureLogs()) {
            System.setOut(printStream);
            System.setErr(printStream);
        }
        try {
            testCode.run();
        }
        catch (Throwable t) {
            Throwable throwable = t;
            exception = throwable instanceof Exception ? t : (throwable instanceof AssertionError ? t : (Throwable)new Exception("Unexpected Throwable in test. Message: '" + t.getMessage() + "'", t));
        }
        finally {
            System.out.flush();
            System.err.flush();
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        return new RunResult(out.toString(), exception);
    }

    static /* synthetic */ RunResult runAndCaptureLogs$default(TestTool testTool, TestConfig testConfig, Runnable runnable, int n, Object object) {
        if ((n & 1) != 0) {
            testConfig = testTool.testConfig;
        }
        return testTool.runAndCaptureLogs(testConfig, runnable);
    }

    @JvmOverloads
    public final void test(@NotNull Javalin app, @NotNull TestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        TestTool.test$default(this, app, null, testCase, 2, null);
    }

    @JvmOverloads
    public final void test(@NotNull TestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        TestTool.test$default(this, null, null, testCase, 3, null);
    }

    private static final void test$lambda$0(Javalin $app, TestConfig $config, TestCase $testCase) {
        $app.start(0);
        HttpClient http = new HttpClient($app, $config.getHttpClient(), $config.getDefaultHeaders());
        $testCase.accept($app, http);
        if ($config.getClearCookies()) {
            String endpointUrl = "/clear-cookies-" + UUID.randomUUID();
            $app.unsafe.routes.delete(endpointUrl, TestTool::test$lambda$0$0);
            http.request(endpointUrl, TestTool::test$lambda$0$1);
        }
        $app.stop();
    }

    private static final void test$lambda$0$0(Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map $this$forEach$iv = it.cookieMap();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            it.removeCookie(k);
        }
    }

    private static final void test$lambda$0$1(Request.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Request.Builder.delete$default(it, null, 1, null);
    }

    public TestTool() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/javalin/testtools/TestTool$Companion;", "", "<init>", "()V", "TestLogsKey", "Lio/javalin/config/Key;", "", "javalin-testtools"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/javalin/testtools/TestTool$RunResult;", "", "logs", "", "exception", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getLogs", "()Ljava/lang/String;", "getException", "()Ljava/lang/Throwable;", "javalin-testtools"})
    public static final class RunResult {
        @Nullable
        private final String logs;
        @Nullable
        private final Throwable exception;

        public RunResult(@Nullable String logs, @Nullable Throwable exception) {
            this.logs = logs;
            this.exception = exception;
        }

        @Nullable
        public final String getLogs() {
            return this.logs;
        }

        @Nullable
        public final Throwable getException() {
            return this.exception;
        }
    }
}

