/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.testtools;

import io.javalin.Javalin;
import io.javalin.json.JsonMapper;
import io.javalin.testtools.Request;
import io.javalin.testtools.Response;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bJ\"\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\n2\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001bH\u0007J.\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001bH\u0007J.\u0010 \u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001bH\u0007J.\u0010!\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001bH\u0007J.\u0010\"\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001bH\u0007J\u000e\u0010#\u001a\u00020$*\u0004\u0018\u00010\u0001H\u0002J,\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/javalin/testtools/HttpClient;", "", "app", "Lio/javalin/Javalin;", "client", "Ljava/net/http/HttpClient;", "<init>", "(Lio/javalin/Javalin;Ljava/net/http/HttpClient;)V", "defaultHeaders", "", "", "(Lio/javalin/Javalin;Ljava/net/http/HttpClient;Ljava/util/Map;)V", "getApp", "()Lio/javalin/Javalin;", "origin", "getOrigin", "()Ljava/lang/String;", "setOrigin", "(Ljava/lang/String;)V", "", "request", "Lio/javalin/testtools/Response;", "Lio/javalin/testtools/Request;", "path", "builder", "Lio/javalin/testtools/Request$Builder;", "userBuilder", "Ljava/util/function/Consumer;", "get", "req", "post", "json", "put", "patch", "delete", "toRequestBodyPublisher", "Ljava/net/http/HttpRequest$BodyPublisher;", "combine", "utilBuilder", "javalin-testtools"})
@SourceDebugExtension(value={"SMAP\nHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClient.kt\nio/javalin/testtools/HttpClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 JsonMapper.kt\nio/javalin/json/JsonMapperKt\n*L\n1#1,215:1\n216#2,2:216\n216#2,2:218\n71#3:220\n*S KotlinDebug\n*F\n+ 1 HttpClient.kt\nio/javalin/testtools/HttpClient\n*L\n137#1:216,2\n142#1:218,2\n203#1:220\n*E\n"})
public final class HttpClient {
    @NotNull
    private final Javalin app;
    @NotNull
    private final java.net.http.HttpClient client;
    @NotNull
    private String origin;
    @NotNull
    private final Map<String, String> defaultHeaders;

    public HttpClient(@NotNull Javalin app, @NotNull java.net.http.HttpClient client) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.app = app;
        this.client = client;
        this.origin = "http://127.0.0.1:" + this.app.port();
        this.defaultHeaders = new LinkedHashMap();
    }

    @NotNull
    public final Javalin getApp() {
        return this.app;
    }

    @NotNull
    public final String getOrigin() {
        return this.origin;
    }

    public final void setOrigin(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.origin = string;
    }

    public HttpClient(@NotNull Javalin app, @NotNull java.net.http.HttpClient client, @NotNull Map<String, String> defaultHeaders) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(defaultHeaders, (String)"defaultHeaders");
        this(app, client);
        this.defaultHeaders.putAll(defaultHeaders);
    }

    @NotNull
    public final Response request(@NotNull Request request) {
        String value;
        String name;
        Map.Entry<String, String> entry;
        Map.Entry<String, String> element$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(request.getUrl()));
        String string = request.getMethod();
        HttpRequest.BodyPublisher bodyPublisher = request.getBodyPublisher();
        if (bodyPublisher == null) {
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        }
        HttpRequest.Builder builder2 = builder.method(string, bodyPublisher);
        Map<String, String> $this$forEach$iv = this.defaultHeaders;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            name = entry.getKey();
            value = entry.getValue();
            builder2.header(name, value);
        }
        $this$forEach$iv = request.getHeaders();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            name = entry.getKey();
            value = entry.getValue();
            builder2.header(name, value);
        }
        HttpRequest httpRequest = builder2.build();
        HttpResponse<String> response = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        Intrinsics.checkNotNull(response);
        return new Response(response);
    }

    @NotNull
    public final Response request(@NotNull String path, @NotNull Request.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return this.request(builder.url(this.origin + path).build());
    }

    @NotNull
    public final Response request(@NotNull String path, @NotNull Consumer<Request.Builder> userBuilder) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(userBuilder, (String)"userBuilder");
        Request.Builder finalBuilder = new Request.Builder();
        userBuilder.accept(finalBuilder);
        return this.request(finalBuilder.url(this.origin + path).build());
    }

    @JvmOverloads
    @NotNull
    public final Response get(@NotNull String path, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, HttpClient::get$lambda$0));
    }

    public static /* synthetic */ Response get$default(HttpClient httpClient, String string, Consumer consumer, int n, Object object) {
        if ((n & 2) != 0) {
            consumer = null;
        }
        return httpClient.get(string, consumer);
    }

    @JvmOverloads
    @NotNull
    public final Response post(@NotNull String path, @Nullable Object json, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, arg_0 -> HttpClient.post$lambda$0(this, json, arg_0)));
    }

    public static /* synthetic */ Response post$default(HttpClient httpClient, String string, Object object, Consumer consumer, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            consumer = null;
        }
        return httpClient.post(string, object, consumer);
    }

    @JvmOverloads
    @NotNull
    public final Response put(@NotNull String path, @Nullable Object json, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, arg_0 -> HttpClient.put$lambda$0(this, json, arg_0)));
    }

    public static /* synthetic */ Response put$default(HttpClient httpClient, String string, Object object, Consumer consumer, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            consumer = null;
        }
        return httpClient.put(string, object, consumer);
    }

    @JvmOverloads
    @NotNull
    public final Response patch(@NotNull String path, @Nullable Object json, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, arg_0 -> HttpClient.patch$lambda$0(this, json, arg_0)));
    }

    public static /* synthetic */ Response patch$default(HttpClient httpClient, String string, Object object, Consumer consumer, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            consumer = null;
        }
        return httpClient.patch(string, object, consumer);
    }

    @JvmOverloads
    @NotNull
    public final Response delete(@NotNull String path, @Nullable Object json, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, arg_0 -> HttpClient.delete$lambda$0(this, json, arg_0)));
    }

    public static /* synthetic */ Response delete$default(HttpClient httpClient, String string, Object object, Consumer consumer, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            consumer = null;
        }
        return httpClient.delete(string, object, consumer);
    }

    /*
     * WARNING - void declaration
     */
    private final HttpRequest.BodyPublisher toRequestBodyPublisher(Object $this$toRequestBodyPublisher) {
        HttpRequest.BodyPublisher bodyPublisher;
        if ($this$toRequestBodyPublisher == null) {
            HttpRequest.BodyPublisher bodyPublisher2 = HttpRequest.BodyPublishers.noBody();
            Intrinsics.checkNotNull((Object)bodyPublisher2);
            bodyPublisher = bodyPublisher2;
        } else {
            void $this$toJsonString$iv;
            JsonMapper jsonMapper = (JsonMapper)this.app.unsafe.jsonMapper.getValue();
            Object obj$iv = $this$toRequestBodyPublisher;
            boolean $i$f$toJsonString = false;
            String jsonString = $this$toJsonString$iv.toJsonString(obj$iv, TypesJVMKt.getJavaType((KType)Reflection.typeOf(Object.class)));
            HttpRequest.BodyPublisher bodyPublisher3 = HttpRequest.BodyPublishers.ofString(jsonString, StandardCharsets.UTF_8);
            Intrinsics.checkNotNull((Object)bodyPublisher3);
            bodyPublisher = bodyPublisher3;
        }
        return bodyPublisher;
    }

    private final Consumer<Request.Builder> combine(Consumer<Request.Builder> userBuilder, Consumer<Request.Builder> utilBuilder) {
        return arg_0 -> HttpClient.combine$lambda$0(userBuilder, utilBuilder, arg_0);
    }

    @JvmOverloads
    @NotNull
    public final Response get(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.get$default(this, path, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Response post(@NotNull String path, @Nullable Object json) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.post$default(this, path, json, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Response post(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.post$default(this, path, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Response put(@NotNull String path, @Nullable Object json) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.put$default(this, path, json, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Response put(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.put$default(this, path, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Response patch(@NotNull String path, @Nullable Object json) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.patch$default(this, path, json, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Response patch(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.patch$default(this, path, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Response delete(@NotNull String path, @Nullable Object json) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.delete$default(this, path, json, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Response delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.delete$default(this, path, null, null, 6, null);
    }

    private static final void get$lambda$0(Request.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.get();
    }

    private static final void post$lambda$0(HttpClient this$0, Object $json, Request.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.post(this$0.toRequestBodyPublisher($json));
        if ($json != null) {
            builder.header("Content-Type", "application/json");
        }
    }

    private static final void put$lambda$0(HttpClient this$0, Object $json, Request.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.put(this$0.toRequestBodyPublisher($json));
        if ($json != null) {
            builder.header("Content-Type", "application/json");
        }
    }

    private static final void patch$lambda$0(HttpClient this$0, Object $json, Request.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.patch(this$0.toRequestBodyPublisher($json));
        if ($json != null) {
            builder.header("Content-Type", "application/json");
        }
    }

    private static final void delete$lambda$0(HttpClient this$0, Object $json, Request.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.delete(this$0.toRequestBodyPublisher($json));
        if ($json != null) {
            builder.header("Content-Type", "application/json");
        }
    }

    private static final void combine$lambda$0(Consumer $userBuilder, Consumer $utilBuilder, Request.Builder finalBuilder) {
        Intrinsics.checkNotNullParameter((Object)finalBuilder, (String)"finalBuilder");
        Consumer consumer = $userBuilder;
        if (consumer != null) {
            consumer.accept(finalBuilder);
        }
        $utilBuilder.accept(finalBuilder);
    }
}

