/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.testtools;

import io.javalin.testtools.FormBody;
import java.net.http.HttpRequest;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001\u0012B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lio/javalin/testtools/Request;", "", "url", "", "method", "headers", "", "bodyPublisher", "Ljava/net/http/HttpRequest$BodyPublisher;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/net/http/HttpRequest$BodyPublisher;)V", "getUrl", "()Ljava/lang/String;", "getMethod", "getHeaders", "()Ljava/util/Map;", "getBodyPublisher", "()Ljava/net/http/HttpRequest$BodyPublisher;", "Builder", "javalin-testtools"})
public final class Request {
    @NotNull
    private final String url;
    @NotNull
    private final String method;
    @NotNull
    private final Map<String, String> headers;
    @Nullable
    private final HttpRequest.BodyPublisher bodyPublisher;

    private Request(String url, String method, Map<String, String> headers, HttpRequest.BodyPublisher bodyPublisher) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.bodyPublisher = bodyPublisher;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @Nullable
    public final HttpRequest.BodyPublisher getBodyPublisher() {
        return this.bodyPublisher;
    }

    public /* synthetic */ Request(String url, String method, Map headers, HttpRequest.BodyPublisher bodyPublisher, DefaultConstructorMarker $constructor_marker) {
        this(url, method, headers, bodyPublisher);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\nJ\u0012\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/javalin/testtools/Request$Builder;", "", "<init>", "()V", "url", "", "method", "headers", "", "bodyPublisher", "Ljava/net/http/HttpRequest$BodyPublisher;", "header", "name", "value", "get", "post", "body", "formBody", "Lio/javalin/testtools/FormBody;", "put", "patch", "delete", "build", "Lio/javalin/testtools/Request;", "javalin-testtools"})
    public static final class Builder {
        @NotNull
        private String url = "";
        @NotNull
        private String method = "GET";
        @NotNull
        private final Map<String, String> headers = new LinkedHashMap();
        @Nullable
        private HttpRequest.BodyPublisher bodyPublisher;

        @NotNull
        public final Builder url(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            return this;
        }

        @NotNull
        public final Builder header(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.headers.put(name, value);
            return this;
        }

        @NotNull
        public final Builder get() {
            this.method = "GET";
            this.bodyPublisher = null;
            return this;
        }

        @NotNull
        public final Builder post(@NotNull HttpRequest.BodyPublisher body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            this.method = "POST";
            this.bodyPublisher = body;
            return this;
        }

        @NotNull
        public final Builder post(@NotNull FormBody formBody) {
            Intrinsics.checkNotNullParameter((Object)formBody, (String)"formBody");
            this.method = "POST";
            this.bodyPublisher = formBody.toBodyPublisher();
            this.header("Content-Type", "application/x-www-form-urlencoded");
            return this;
        }

        @NotNull
        public final Builder put(@NotNull HttpRequest.BodyPublisher body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            this.method = "PUT";
            this.bodyPublisher = body;
            return this;
        }

        @NotNull
        public final Builder patch(@NotNull HttpRequest.BodyPublisher body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            this.method = "PATCH";
            this.bodyPublisher = body;
            return this;
        }

        @NotNull
        public final Builder delete(@Nullable HttpRequest.BodyPublisher body) {
            this.method = "DELETE";
            this.bodyPublisher = body;
            return this;
        }

        public static /* synthetic */ Builder delete$default(Builder builder, HttpRequest.BodyPublisher bodyPublisher, int n, Object object) {
            if ((n & 1) != 0) {
                bodyPublisher = null;
            }
            return builder.delete(bodyPublisher);
        }

        @NotNull
        public final Request build() {
            return new Request(this.url, this.method, MapsKt.toMap(this.headers), this.bodyPublisher, null);
        }
    }
}

