/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javaslang.jackson.datatype.deserialize.ValueDeserializer;

abstract class ArrayDeserializer<T>
extends ValueDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private final JavaType valueType;
    private final boolean deserializeNullAsEmptyCollection;

    ArrayDeserializer(JavaType valueType, int typeCount, boolean deserializeNullAsEmptyCollection) {
        super(valueType, typeCount);
        this.valueType = valueType;
        this.deserializeNullAsEmptyCollection = deserializeNullAsEmptyCollection;
    }

    abstract T create(List<Object> var1, DeserializationContext var2) throws JsonMappingException;

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonDeserializer<?> deserializer = this.deserializer(0);
        ArrayList<Object> list = new ArrayList<Object>();
        if (!p.isExpectedStartArrayToken()) {
            throw ctxt.mappingException(this.valueType.getRawClass());
        }
        JsonToken jsonToken = p.nextToken();
        while (jsonToken != JsonToken.END_ARRAY) {
            Object value = jsonToken != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
            list.add(value);
            jsonToken = p.nextToken();
        }
        return this.create(list, ctxt);
    }

    public T getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        if (this.deserializeNullAsEmptyCollection) {
            return this.create(Collections.emptyList(), ctxt);
        }
        return (T)super.getNullValue(ctxt);
    }

    static void checkContainedTypeIsComparable(DeserializationContext ctxt, JavaType type) throws JsonMappingException {
        Class clz = type.getRawClass();
        if (clz == Object.class || !Comparable.class.isAssignableFrom(clz)) {
            throw ctxt.mappingException(clz);
        }
    }
}

