/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import javaslang.control.Either;
import javaslang.jackson.datatype.deserialize.ValueDeserializer;

class EitherDeserializer
extends ValueDeserializer<Either<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private JsonDeserializer<?> stringDeserializer;

    EitherDeserializer(JavaType valueType) {
        super(valueType, 2);
        this.javaType = valueType;
    }

    public Either<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        boolean right = false;
        Object value = null;
        int cnt = 0;
        JsonToken jsonToken = p.nextToken();
        while (jsonToken != JsonToken.END_ARRAY) {
            switch (++cnt) {
                case 1: {
                    String def = (String)this.stringDeserializer.deserialize(p, ctxt);
                    if ("right".equals(def)) {
                        right = true;
                        break;
                    }
                    if ("left".equals(def)) {
                        right = false;
                        break;
                    }
                    throw ctxt.mappingException(this.javaType.getRawClass());
                }
                case 2: {
                    JsonDeserializer<?> deserializer = right ? this.deserializer(1) : this.deserializer(0);
                    value = jsonToken != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
                }
            }
            jsonToken = p.nextToken();
        }
        if (cnt != 2) {
            throw ctxt.mappingException(this.javaType.getRawClass());
        }
        return right ? Either.right(value) : Either.left(value);
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        super.resolve(ctxt);
        this.stringDeserializer = ctxt.findContextualValueDeserializer(ctxt.constructType(String.class), null);
    }
}

