/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import javaslang.Lazy;
import javaslang.Tuple;
import javaslang.collection.CharSeq;
import javaslang.collection.Map;
import javaslang.collection.Multimap;
import javaslang.collection.PriorityQueue;
import javaslang.collection.Seq;
import javaslang.collection.Set;
import javaslang.control.Either;
import javaslang.control.Option;
import javaslang.jackson.datatype.JavaslangModule;
import javaslang.jackson.datatype.deserialize.CharSeqDeserializer;
import javaslang.jackson.datatype.deserialize.EitherDeserializer;
import javaslang.jackson.datatype.deserialize.LazyDeserializer;
import javaslang.jackson.datatype.deserialize.MapDeserializer;
import javaslang.jackson.datatype.deserialize.MultimapDeserializer;
import javaslang.jackson.datatype.deserialize.OptionDeserializer;
import javaslang.jackson.datatype.deserialize.PriorityQueueDeserializer;
import javaslang.jackson.datatype.deserialize.SeqDeserializer;
import javaslang.jackson.datatype.deserialize.SerializableDeserializer;
import javaslang.jackson.datatype.deserialize.SetDeserializer;
import javaslang.jackson.datatype.deserialize.TupleDeserializer;
import javaslang.\u03bb;

public class JavaslangDeserializers
extends Deserializers.Base {
    private final JavaslangModule.Settings settings;

    public JavaslangDeserializers(JavaslangModule.Settings settings) {
        this.settings = settings;
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (CharSeq.class.isAssignableFrom(raw)) {
            return new CharSeqDeserializer(type);
        }
        if (Lazy.class.isAssignableFrom(raw)) {
            return new LazyDeserializer(type);
        }
        if (Option.class.isAssignableFrom(raw)) {
            return new OptionDeserializer(type, this.settings.useOptionInPlainFormat());
        }
        if (Either.class.isAssignableFrom(raw)) {
            return new EitherDeserializer(type);
        }
        if (Map.class.isAssignableFrom(raw)) {
            return new MapDeserializer(type);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new MultimapDeserializer(type);
        }
        if (Tuple.class.isAssignableFrom(raw)) {
            return new TupleDeserializer(type);
        }
        if (\u03bb.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (Seq.class.isAssignableFrom(raw)) {
            return new SeqDeserializer((JavaType)type, this.settings.deserializeNullAsEmptyCollection());
        }
        if (Set.class.isAssignableFrom(raw)) {
            return new SetDeserializer((JavaType)type, this.settings.deserializeNullAsEmptyCollection());
        }
        if (PriorityQueue.class.isAssignableFrom(raw)) {
            return new PriorityQueueDeserializer((JavaType)type, this.settings.deserializeNullAsEmptyCollection());
        }
        return super.findCollectionLikeDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }
}

