/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.HashMap;
import javaslang.collection.LinkedHashMap;
import javaslang.collection.Map;
import javaslang.collection.TreeMap;
import javaslang.jackson.datatype.deserialize.MaplikeDeserializer;

class MapDeserializer
extends MaplikeDeserializer<Map<?, ?>> {
    private static final long serialVersionUID = 1L;

    MapDeserializer(JavaType valueType) {
        super(valueType);
    }

    public Map<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        while (p.nextToken() != JsonToken.END_OBJECT) {
            String name = p.getCurrentName();
            Object key = this.keyDeserializer.deserializeKey(name, ctxt);
            p.nextToken();
            result.add(Tuple.of((Object)key, (Object)this.valueDeserializer.deserialize(p, ctxt)));
        }
        if (TreeMap.class.isAssignableFrom(this.handledType())) {
            return TreeMap.ofEntries((Comparator)this.keyComparator, result);
        }
        if (LinkedHashMap.class.isAssignableFrom(this.handledType())) {
            return LinkedHashMap.ofEntries(result);
        }
        return HashMap.ofEntries(result);
    }
}

