/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import java.util.Comparator;

abstract class MaplikeDeserializer<T>
extends StdDeserializer<T>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    MapLikeType mapLikeType;
    Comparator<Object> keyComparator;
    KeyDeserializer keyDeserializer;
    JsonDeserializer<?> valueDeserializer;

    MaplikeDeserializer(JavaType valueType) {
        super(valueType);
        this.javaType = valueType;
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        this.mapLikeType = MaplikeDeserializer.mapLike(this.javaType, ctxt);
        JavaType keyType = this.mapLikeType.getKeyType();
        this.keyComparator = keyType.getRawClass().isAssignableFrom(Comparable.class) ? (o1, o2) -> ((Comparable)o1).compareTo(o2) : (o1, o2) -> o1.toString().compareTo(o2.toString());
        this.keyDeserializer = ctxt.findKeyDeserializer(keyType, null);
        this.valueDeserializer = ctxt.findRootValueDeserializer(this.mapLikeType.getContentType());
    }

    private static MapLikeType mapLike(JavaType type, DeserializationContext ctxt) {
        JavaType keyType = type.containedTypeOrUnknown(0);
        JavaType valueType = type.containedTypeOrUnknown(1);
        return ctxt.getTypeFactory().constructMapLikeType(type.getRawClass(), keyType, valueType);
    }
}

