/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.HashMultimap;
import javaslang.collection.LinkedHashMultimap;
import javaslang.collection.Multimap;
import javaslang.collection.TreeMultimap;
import javaslang.jackson.datatype.deserialize.MaplikeDeserializer;

class MultimapDeserializer
extends MaplikeDeserializer<Multimap<?, ?>> {
    private static final long serialVersionUID = 1L;
    private JsonDeserializer<?> containerDeserializer;

    MultimapDeserializer(JavaType valueType) {
        super(valueType);
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        super.resolve(ctxt);
        CollectionType containerType = CollectionType.construct(ArrayList.class, (JavaType)this.mapLikeType.getContentType());
        this.containerDeserializer = ctxt.findContextualValueDeserializer((JavaType)containerType, null);
    }

    public Multimap<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        while (p.nextToken() != JsonToken.END_OBJECT) {
            String name = p.getCurrentName();
            Object key = this.keyDeserializer.deserializeKey(name, ctxt);
            p.nextToken();
            ArrayList list = (ArrayList)this.containerDeserializer.deserialize(p, ctxt);
            for (Object elem : list) {
                result.add(Tuple.of((Object)key, elem));
            }
        }
        if (TreeMultimap.class.isAssignableFrom(this.handledType())) {
            return TreeMultimap.withSeq().ofEntries(this.keyComparator, result);
        }
        if (LinkedHashMultimap.class.isAssignableFrom(this.handledType())) {
            return LinkedHashMultimap.withSeq().ofEntries(result);
        }
        return HashMultimap.withSeq().ofEntries(result);
    }
}

