/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import javaslang.control.Option;
import javaslang.jackson.datatype.deserialize.ValueDeserializer;

class OptionDeserializer
extends ValueDeserializer<Option<?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private final boolean plainMode;
    private JsonDeserializer<?> stringDeserializer;

    OptionDeserializer(JavaType valueType, boolean plainMode) {
        super(valueType, 1);
        this.javaType = valueType;
        this.plainMode = plainMode;
    }

    public Option<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this.plainMode) {
            Object obj = this.deserializer(0).deserialize(p, ctxt);
            return Option.of((Object)obj);
        }
        boolean defined = false;
        Object value = null;
        int cnt = 0;
        while (p.nextToken() != JsonToken.END_ARRAY) {
            switch (++cnt) {
                case 1: {
                    String def = (String)this.stringDeserializer.deserialize(p, ctxt);
                    if ("defined".equals(def)) {
                        defined = true;
                        break;
                    }
                    if ("undefined".equals(def)) {
                        defined = false;
                        break;
                    }
                    throw ctxt.mappingException(this.javaType.getRawClass());
                }
                case 2: {
                    value = this.deserializer(0).deserialize(p, ctxt);
                }
            }
        }
        if (defined) {
            if (cnt != 2) {
                throw ctxt.mappingException(this.javaType.getRawClass());
            }
            return Option.some(value);
        }
        if (cnt != 1) {
            throw ctxt.mappingException(this.javaType.getRawClass());
        }
        return Option.none();
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        super.resolve(ctxt);
        this.stringDeserializer = ctxt.findContextualValueDeserializer(ctxt.constructType(String.class), null);
    }

    public Option<?> getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        return Option.none();
    }
}

