/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import javaslang.collection.Array;
import javaslang.collection.List;
import javaslang.collection.Queue;
import javaslang.collection.Seq;
import javaslang.collection.Stream;
import javaslang.collection.Vector;
import javaslang.jackson.datatype.deserialize.ArrayDeserializer;

class SeqDeserializer
extends ArrayDeserializer<Seq<?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;

    SeqDeserializer(JavaType valueType, boolean deserializeNullAsEmptyCollection) {
        super(valueType, 1, deserializeNullAsEmptyCollection);
        this.javaType = valueType;
    }

    @Override
    Seq<?> create(java.util.List<Object> result, DeserializationContext ctxt) throws JsonMappingException {
        if (Array.class.isAssignableFrom(this.javaType.getRawClass())) {
            return Array.ofAll(result);
        }
        if (Queue.class.isAssignableFrom(this.javaType.getRawClass())) {
            return Queue.ofAll(result);
        }
        if (Stream.class.isAssignableFrom(this.javaType.getRawClass())) {
            return Stream.ofAll(result);
        }
        if (Vector.class.isAssignableFrom(this.javaType.getRawClass())) {
            return Vector.ofAll(result);
        }
        return List.ofAll(result);
    }
}

