/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.util.List;
import javaslang.collection.HashSet;
import javaslang.collection.LinkedHashSet;
import javaslang.collection.Set;
import javaslang.collection.SortedSet;
import javaslang.collection.TreeSet;
import javaslang.jackson.datatype.deserialize.ArrayDeserializer;

class SetDeserializer
extends ArrayDeserializer<Set<?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;

    SetDeserializer(JavaType valueType, boolean deserializeNullAsEmptyCollection) {
        super(valueType, 1, deserializeNullAsEmptyCollection);
        this.javaType = valueType;
    }

    @Override
    Set<?> create(List<Object> result, DeserializationContext ctx) throws JsonMappingException {
        if (SortedSet.class.isAssignableFrom(this.javaType.getRawClass())) {
            SetDeserializer.checkContainedTypeIsComparable(ctx, this.javaType.containedTypeOrUnknown(0));
            return TreeSet.ofAll((o1, o2) -> ((Comparable)o1).compareTo(o2), result);
        }
        if (LinkedHashSet.class.isAssignableFrom(this.javaType.getRawClass())) {
            return LinkedHashSet.ofAll(result);
        }
        return HashSet.ofAll(result);
    }
}

