/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javaslang.Tuple;
import javaslang.Tuple0;
import javaslang.Tuple1;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.Tuple4;
import javaslang.Tuple5;
import javaslang.Tuple6;
import javaslang.Tuple7;
import javaslang.jackson.datatype.deserialize.ValueDeserializer;

class TupleDeserializer
extends ValueDeserializer<Tuple> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;

    TupleDeserializer(JavaType valueType) {
        super(valueType, TupleDeserializer.arity(valueType));
        this.javaType = valueType;
    }

    public Tuple deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ArrayList<Object> list = new ArrayList<Object>();
        int ptr = 0;
        JsonToken jsonToken = p.nextToken();
        while (jsonToken != JsonToken.END_ARRAY) {
            if (ptr >= this.deserializersCount()) {
                throw ctxt.mappingException(this.javaType.getRawClass());
            }
            JsonDeserializer<?> deserializer = this.deserializer(ptr++);
            Object value = jsonToken != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
            list.add(value);
            jsonToken = p.nextToken();
        }
        return this.create(list, ctxt);
    }

    private Tuple create(List<Object> list, DeserializationContext ctxt) throws JsonMappingException {
        Tuple0 result;
        switch (list.size()) {
            case 1: {
                result = Tuple.of((Object)list.get(0));
                break;
            }
            case 2: {
                result = Tuple.of((Object)list.get(0), (Object)list.get(1));
                break;
            }
            case 3: {
                result = Tuple.of((Object)list.get(0), (Object)list.get(1), (Object)list.get(2));
                break;
            }
            case 4: {
                result = Tuple.of((Object)list.get(0), (Object)list.get(1), (Object)list.get(2), (Object)list.get(3));
                break;
            }
            case 5: {
                result = Tuple.of((Object)list.get(0), (Object)list.get(1), (Object)list.get(2), (Object)list.get(3), (Object)list.get(4));
                break;
            }
            case 6: {
                result = Tuple.of((Object)list.get(0), (Object)list.get(1), (Object)list.get(2), (Object)list.get(3), (Object)list.get(4), (Object)list.get(5));
                break;
            }
            case 7: {
                result = Tuple.of((Object)list.get(0), (Object)list.get(1), (Object)list.get(2), (Object)list.get(3), (Object)list.get(4), (Object)list.get(5), (Object)list.get(6));
                break;
            }
            case 8: {
                result = Tuple.of((Object)list.get(0), (Object)list.get(1), (Object)list.get(2), (Object)list.get(3), (Object)list.get(4), (Object)list.get(5), (Object)list.get(6), (Object)list.get(7));
                break;
            }
            default: {
                result = Tuple.empty();
            }
        }
        if (!this.javaType.getRawClass().isAssignableFrom(result.getClass())) {
            throw ctxt.mappingException(this.javaType.getRawClass());
        }
        return result;
    }

    private static int arity(JavaType valueType) {
        Class clz = valueType.getRawClass();
        if (clz == Tuple0.class) {
            return 0;
        }
        if (clz == Tuple1.class) {
            return 1;
        }
        if (clz == Tuple2.class) {
            return 2;
        }
        if (clz == Tuple3.class) {
            return 3;
        }
        if (clz == Tuple4.class) {
            return 4;
        }
        if (clz == Tuple5.class) {
            return 5;
        }
        if (clz == Tuple6.class) {
            return 6;
        }
        if (clz == Tuple7.class) {
            return 7;
        }
        return 8;
    }
}

