/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.ArrayList;
import java.util.List;

abstract class ValueDeserializer<T>
extends StdDeserializer<T>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private final int typeCount;
    private final List<JsonDeserializer<?>> deserializers;

    ValueDeserializer(JavaType valueType, int typeCount) {
        super(valueType);
        this.javaType = valueType;
        this.typeCount = typeCount;
        this.deserializers = new ArrayList(typeCount);
    }

    int deserializersCount() {
        return this.deserializers.size();
    }

    JsonDeserializer<?> deserializer(int index) {
        return this.deserializers.get(index);
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        for (int i = 0; i < this.typeCount; ++i) {
            this.deserializers.add(ctxt.findRootValueDeserializer(this.javaType.containedTypeOrUnknown(i)));
        }
    }
}

