/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.serialize;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import javaslang.Value;
import javaslang.jackson.datatype.serialize.ValueSerializer;

class ArraySerializer<T extends Value<?>>
extends ValueSerializer<T> {
    private static final long serialVersionUID = 1L;

    ArraySerializer(JavaType type) {
        super(type);
    }

    @Override
    Object toJavaObj(T value) throws IOException {
        return value.toJavaList();
    }

    @Override
    JavaType emulatedJavaType(JavaType type) {
        return CollectionType.construct(ArrayList.class, (JavaType)type.containedType(0));
    }

    public boolean isEmpty(SerializerProvider provider, T value) {
        return value.isEmpty();
    }
}

