/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.serialize;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import javaslang.Lazy;
import javaslang.Tuple;
import javaslang.collection.CharSeq;
import javaslang.collection.Map;
import javaslang.collection.Multimap;
import javaslang.collection.PriorityQueue;
import javaslang.collection.Seq;
import javaslang.collection.Set;
import javaslang.control.Either;
import javaslang.control.Option;
import javaslang.jackson.datatype.JavaslangModule;
import javaslang.jackson.datatype.serialize.ArraySerializer;
import javaslang.jackson.datatype.serialize.CharSeqSerializer;
import javaslang.jackson.datatype.serialize.EitherSerializer;
import javaslang.jackson.datatype.serialize.LazySerializer;
import javaslang.jackson.datatype.serialize.MapSerializer;
import javaslang.jackson.datatype.serialize.MultimapSerializer;
import javaslang.jackson.datatype.serialize.OptionSerializer;
import javaslang.jackson.datatype.serialize.SerializableSerializer;
import javaslang.jackson.datatype.serialize.TupleSerializer;
import javaslang.\u03bb;

public class JavaslangSerializers
extends Serializers.Base {
    private final JavaslangModule.Settings settings;

    public JavaslangSerializers(JavaslangModule.Settings settings) {
        this.settings = settings;
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class raw = type.getRawClass();
        if (Lazy.class.isAssignableFrom(raw)) {
            return new LazySerializer(type);
        }
        if (Option.class.isAssignableFrom(raw)) {
            return new OptionSerializer(type, this.settings.useOptionInPlainFormat());
        }
        if (Either.class.isAssignableFrom(raw)) {
            return new EitherSerializer(type);
        }
        if (CharSeq.class.isAssignableFrom(raw)) {
            return new CharSeqSerializer(type);
        }
        if (Map.class.isAssignableFrom(raw)) {
            return new MapSerializer(type);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new MultimapSerializer(type);
        }
        if (Tuple.class.isAssignableFrom(raw)) {
            return new TupleSerializer(type);
        }
        if (\u03bb.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        return super.findSerializer(config, type, beanDesc);
    }

    public JsonSerializer<?> findCollectionLikeSerializer(SerializationConfig config, CollectionLikeType type, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class raw = type.getRawClass();
        if (Seq.class.isAssignableFrom(raw)) {
            return new ArraySerializer((JavaType)type);
        }
        if (Set.class.isAssignableFrom(raw)) {
            return new ArraySerializer((JavaType)type);
        }
        if (PriorityQueue.class.isAssignableFrom(raw)) {
            return new ArraySerializer((JavaType)type);
        }
        return super.findCollectionLikeSerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer);
    }
}

