/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.serialize;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.LinkedHashMap;
import javaslang.collection.Map;
import javaslang.jackson.datatype.serialize.ValueSerializer;

class MapSerializer
extends ValueSerializer<Map<?, ?>> {
    private static final long serialVersionUID = 1L;

    MapSerializer(JavaType type) {
        super(type);
    }

    @Override
    Object toJavaObj(Map<?, ?> value) throws IOException {
        LinkedHashMap result = new LinkedHashMap();
        value.forEach(e -> result.put(e._1, e._2));
        return result;
    }

    @Override
    JavaType emulatedJavaType(JavaType type) {
        return MapType.construct(LinkedHashMap.class, (JavaType)type.containedType(0), (JavaType)type.containedType(1));
    }

    public boolean isEmpty(SerializerProvider provider, Map<?, ?> value) {
        return value.isEmpty();
    }
}

