/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import javaslang.control.Option;
import javaslang.jackson.datatype.serialize.ValueSerializer;

class OptionSerializer
extends ValueSerializer<Option<?>> {
    private static final long serialVersionUID = 1L;
    private final boolean plainMode;

    OptionSerializer(JavaType type, boolean plainMode) {
        super(type);
        this.plainMode = plainMode;
    }

    @Override
    public void serialize(Option<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this.plainMode) {
            super.serialize(value, gen, provider);
        } else {
            gen.writeStartArray();
            if (value.isDefined()) {
                gen.writeString("defined");
                super.serialize(value, gen, provider);
            } else {
                gen.writeString("undefined");
            }
            gen.writeEndArray();
        }
    }

    @Override
    Object toJavaObj(Option<?> value) throws IOException {
        if (value.isDefined()) {
            return value.get();
        }
        return null;
    }

    @Override
    JavaType emulatedJavaType(JavaType type) {
        return type.containedType(0);
    }

    public boolean isEmpty(SerializerProvider provider, Option<?> value) {
        return value.isEmpty();
    }
}

