/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.serialize;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javaslang.jackson.datatype.serialize.ValueSerializer;

class SerializableSerializer<T>
extends ValueSerializer<T> {
    private static final long serialVersionUID = 1L;

    SerializableSerializer(JavaType type) {
        super(type);
    }

    @Override
    Object toJavaObj(T value) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(buf);
        stream.writeObject(value);
        return buf.toByteArray();
    }

    @Override
    JavaType emulatedJavaType(JavaType type) {
        return ArrayType.construct((JavaType)SimpleType.construct(Byte.TYPE), null, null);
    }
}

