/*
 * Decompiled with CFR 0.152.
 */
package javaslang.jackson.datatype.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

abstract class ValueSerializer<T>
extends StdSerializer<T> {
    private static final long serialVersionUID = 1L;
    JavaType type;

    ValueSerializer(JavaType type) {
        super(type);
        this.type = type;
    }

    abstract Object toJavaObj(T var1) throws IOException;

    abstract JavaType emulatedJavaType(JavaType var1);

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Object obj = this.toJavaObj(value);
        if (obj == null) {
            provider.getDefaultNullValueSerializer().serialize(null, gen, provider);
        } else {
            JsonSerializer ser;
            try {
                JavaType emulated = this.emulatedJavaType(this.type);
                ser = emulated.getRawClass() != Object.class ? provider.findTypedValueSerializer(emulated, true, null) : provider.findTypedValueSerializer(obj.getClass(), true, null);
            }
            catch (Exception ignore) {
                ser = provider.findTypedValueSerializer(obj.getClass(), true, null);
            }
            ser.serialize(obj, gen, provider);
        }
    }

    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForScalar(value, gen);
    }
}

