/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.ext.TreeGene;
import io.jenetics.internal.util.Hashes;
import io.jenetics.util.ISeq;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractTreeGene<A, G extends AbstractTreeGene<A, G>>
implements TreeGene<A, G>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final A _allele;
    private final int _childOffset;
    private final int _childCount;
    private ISeq<G> _genes;

    protected AbstractTreeGene(A allele, int childOffset, int childCount) {
        if (childCount < 0) {
            throw new IllegalArgumentException(String.format("Child count smaller than zero: %s", childCount));
        }
        this._allele = allele;
        this._childOffset = childOffset;
        this._childCount = childCount;
    }

    @Override
    public ISeq<G> flattenedNodes() {
        return this._genes;
    }

    @Override
    public G getRoot() {
        return (G)((AbstractTreeGene)this._genes.get(0));
    }

    @Override
    public boolean isRoot() {
        return this.getRoot() == this;
    }

    @Override
    public int size() {
        return this.isRoot() ? this._genes.size() : TreeGene.super.size();
    }

    protected void checkTreeState() {
        if (this._genes == null) {
            throw new IllegalStateException("Gene is not attached to a chromosome.");
        }
    }

    protected void bind(ISeq<G> genes) {
        this._genes = Objects.requireNonNull(genes);
    }

    @Override
    public int childOffset() {
        return this._childOffset;
    }

    public A getAllele() {
        return this._allele;
    }

    @Override
    public Optional<G> getParent() {
        this.checkTreeState();
        return this._genes.stream().filter(g -> g.childStream().anyMatch(this::identical)).findFirst();
    }

    @Override
    public G childAt(int index) {
        this.checkTreeState();
        if (index < 0 || index >= this.childCount()) {
            throw new IndexOutOfBoundsException(String.format("Child index out of bounds: %s", index));
        }
        assert (this._genes != null);
        return (G)((AbstractTreeGene)this._genes.get(this._childOffset + index));
    }

    @Override
    public int childCount() {
        return this._childCount;
    }

    public boolean isValid() {
        return this._genes != null;
    }

    public int hashCode() {
        return Hashes.hash(this._allele, (int)Hashes.hash((int)this._childOffset, (int)Hashes.hash((int)this._childCount)));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AbstractTreeGene && Objects.equals(((AbstractTreeGene)obj)._allele, this._allele) && ((AbstractTreeGene)obj)._childOffset == this._childOffset && ((AbstractTreeGene)obj)._childCount == this._childCount;
    }

    public String toString() {
        return Objects.toString(this._allele);
    }
}

