/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Mutator;
import io.jenetics.MutatorResult;
import io.jenetics.internal.math.comb;
import io.jenetics.internal.math.probability;
import io.jenetics.util.MSeq;
import java.util.Random;

public class HPRMutator<G extends Gene<?, G>, C extends Comparable<? super C>>
extends Mutator<G, C> {
    public HPRMutator(double probability) {
        super(probability);
    }

    public HPRMutator() {
        this(0.2);
    }

    protected MutatorResult<Chromosome<G>> mutate(Chromosome<G> chromosome, double p, Random random2) {
        MutatorResult result;
        if (chromosome.length() > 1) {
            int P = probability.toInt((double)p);
            int[] points = comb.subset((int)chromosome.length(), (int)2);
            MSeq genes = chromosome.toSeq().copy();
            int mutations = (points[1] - points[0] + 1) / 2;
            int i = points[0];
            for (int j = points[1]; i < j; ++i, --j) {
                genes.swap(i, j);
                if (random2.nextInt() >= P) continue;
                genes.swap(i, random2.nextInt(chromosome.length()));
                ++mutations;
            }
            result = MutatorResult.of((Object)chromosome.newInstance(genes.toISeq()), (int)mutations);
        } else {
            result = MutatorResult.of(chromosome);
        }
        return result;
    }
}

