/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Mutator;
import io.jenetics.MutatorResult;
import io.jenetics.internal.math.comb;
import io.jenetics.util.MSeq;
import java.util.Random;

public class RSMutator<G extends Gene<?, G>, C extends Comparable<? super C>>
extends Mutator<G, C> {
    public RSMutator(double probability2) {
        super(probability2);
    }

    public RSMutator() {
        this(0.2);
    }

    protected MutatorResult<Chromosome<G>> mutate(Chromosome<G> chromosome, double p, Random random2) {
        MutatorResult result;
        if (chromosome.length() > 1) {
            int[] points = comb.subset((int)(chromosome.length() + 1), (int)2);
            MSeq genes = chromosome.toSeq().copy();
            genes.subSeq(points[0], points[1]).reverse();
            result = MutatorResult.of((Object)chromosome.newInstance(genes.toISeq()), (int)(points[1] - points[0] - 1));
        } else {
            result = MutatorResult.of(chromosome);
        }
        return result;
    }
}

