/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext;

import io.jenetics.Crossover;
import io.jenetics.NumericGene;
import io.jenetics.internal.math.base;
import io.jenetics.internal.math.random;
import io.jenetics.internal.util.require;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.util.Random;

public class SimulatedBinaryCrossover<G extends NumericGene<?, G>, C extends Comparable<? super C>>
extends Crossover<G, C> {
    private final double _contiguity;

    public SimulatedBinaryCrossover(double probability2, double contiguity) {
        super(probability2);
        this._contiguity = require.nonNegative((double)contiguity);
    }

    public SimulatedBinaryCrossover(double probability2) {
        this(probability2, 2.5);
    }

    public double getContiguity() {
        return this._contiguity;
    }

    protected int crossover(MSeq<G> that, MSeq<G> other) {
        return (int)random.indexes((Random)RandomRegistry.getRandom(), (int)that.length(), (double)0.5).peek(i -> this.crossover(that, other, i)).count();
    }

    private void crossover(MSeq<G> that, MSeq<G> other, int i) {
        Random random2 = RandomRegistry.getRandom();
        double u = random2.nextDouble();
        double beta = u < 0.5 ? Math.pow(2.0 * u, 1.0 / (this._contiguity + 1.0)) : (u > 0.5 ? Math.pow(0.5 / (1.0 - u), 1.0 / (this._contiguity + 1.0)) : (u == 0.5 ? 1.0 : 0.0));
        double v1 = ((NumericGene)that.get(i)).doubleValue();
        double v2 = ((NumericGene)other.get(i)).doubleValue();
        double v = random2.nextBoolean() ? (v1 - v2) * 0.5 - beta * 0.5 * Math.abs(v1 - v2) : (v1 - v2) * 0.5 + beta * 0.5 * Math.abs(v1 - v2);
        double min = ((Number)((Object)((NumericGene)that.get(i)).getMin())).doubleValue();
        double max = ((Number)((Object)((NumericGene)that.get(i)).getMax())).doubleValue();
        that.set(i, (Object)((NumericGene)that.get(i)).newInstance((Number)base.clamp((double)v, (double)min, (double)max)));
    }

    public String toString() {
        return String.format("SimulatedBinaryCrossover[p=%f, c=%f]", this._probability, this._contiguity);
    }
}

